/*
 * Copyright 2019 Pivotal, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.LoadBalancersDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
abstract class AbstractLoadBalancersAtomicOperationConverter
    extends AbstractCloudFoundryServerGroupAtomicOperationConverter {
  @Override
  public LoadBalancersDescription convertDescription(Map input) {
    List<String> routes = (List<String>) input.get("loadBalancerNames");
    if (routes.isEmpty()) {
      throw new IllegalArgumentException("No routes supplied.");
    }

    LoadBalancersDescription converted =
        getObjectMapper().convertValue(input, LoadBalancersDescription.class);
    CloudFoundryCredentials credentials = getCredentialsObject(input.get("credentials").toString());
    converted.setCredentials(credentials);
    converted.setClient(getClient(input));
    converted.setServerGroupId(
        getServerGroupId(
            converted.getServerGroupName(), converted.getRegion(), converted.getClient()));
    converted.setRoutes(routes);

    return findSpace(converted.getRegion(), converted.getClient())
        .map(converted::setSpace)
        .orElseThrow(() -> new IllegalArgumentException("No space supplied."));
  }
}
