/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Organizations;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.DomainService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Domain;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Page;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Domains {
    private final DomainService api;
    private final Organizations organizations;
    private final LoadingCache<String, CloudFoundryDomain> domainCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, CloudFoundryDomain>(){

        public CloudFoundryDomain load(@Nonnull String guid) throws CloudFoundryApiException, ResourceNotFoundException {
            Resource domain = CloudFoundryClientUtils.safelyCall(() -> Domains.this.api.findSharedDomainById(guid)).orElseGet(() -> CloudFoundryClientUtils.safelyCall(() -> Domains.this.api.findPrivateDomainById(guid)).orElse(null));
            if (domain == null) {
                throw new ResourceNotFoundException();
            }
            return Domains.this.map(domain);
        }
    });

    private CloudFoundryDomain map(Resource<Domain> res) throws CloudFoundryApiException {
        String orgGuid = res.getEntity().getOwningOrganizationGuid();
        return CloudFoundryDomain.builder().id(res.getMetadata().getGuid()).name(res.getEntity().getName()).organization(orgGuid != null ? this.organizations.findById(orgGuid) : null).build();
    }

    @Nullable
    public CloudFoundryDomain findById(String guid) throws CloudFoundryApiException {
        try {
            return (CloudFoundryDomain)this.domainCache.get((Object)guid);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ResourceNotFoundException) {
                return null;
            }
            throw new CloudFoundryApiException(e.getCause(), "Unable to find domain by id");
        }
    }

    public Optional<CloudFoundryDomain> findByName(String domainName) throws CloudFoundryApiException {
        return this.all().stream().filter(d -> d.getName().equals(domainName)).findFirst();
    }

    public List<CloudFoundryDomain> all() throws CloudFoundryApiException {
        List sharedDomains = CloudFoundryClientUtils.collectPageResources("shared domains", this.api::allShared);
        List privateDomains = CloudFoundryClientUtils.collectPageResources("private domains", this.api::allPrivate);
        ArrayList<CloudFoundryDomain> domains = new ArrayList<CloudFoundryDomain>(sharedDomains.size() + privateDomains.size());
        for (Resource<Domain> resource : sharedDomains) {
            domains.add(this.map(resource));
        }
        for (Resource<Domain> resource : privateDomains) {
            domains.add(this.map(resource));
        }
        for (CloudFoundryDomain cloudFoundryDomain : domains) {
            this.domainCache.put((Object)cloudFoundryDomain.getId(), (Object)cloudFoundryDomain);
        }
        return domains;
    }

    public CloudFoundryDomain getDefault() {
        return this.map(((Page)CloudFoundryClientUtils.safelyCall(() -> this.api.all(null)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to retrieve default domain"}))).getResources().iterator().next());
    }

    @Generated
    public Domains(DomainService api, Organizations organizations) {
        this.api = api;
        this.organizations = organizations;
    }
}

