/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Organizations;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.SpaceService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Space;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryOrganization;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Spaces {
    private final SpaceService api;
    private final Organizations organizations;
    private final LoadingCache<String, CloudFoundrySpace> spaceCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, CloudFoundrySpace>(){

        public CloudFoundrySpace load(@Nonnull String guid) throws CloudFoundryApiException, ResourceNotFoundException {
            return CloudFoundryClientUtils.safelyCall(() -> Spaces.this.api.findById(guid)).map(x$0 -> Spaces.this.map((Space)x$0)).orElseThrow(ResourceNotFoundException::new);
        }
    });

    public CloudFoundrySpace findById(String guid) throws CloudFoundryApiException {
        try {
            return (CloudFoundrySpace)this.spaceCache.get((Object)guid);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ResourceNotFoundException) {
                return null;
            }
            throw new CloudFoundryApiException(e.getCause(), "Unable to find space by id");
        }
    }

    public List<CloudFoundrySpace> all() throws CloudFoundryApiException {
        return CloudFoundryClientUtils.collectPages("spaces", page -> this.api.all((Integer)page, null, null)).stream().map(this::map).collect(Collectors.toList());
    }

    @Nullable
    public CloudFoundryServiceInstance getServiceInstanceById(String spaceId, String serviceInstanceName) {
        return CloudFoundryClientUtils.collectPageResources("get service instances by id", pg -> this.api.getServiceInstancesById(spaceId, (Integer)pg, (List<String>)Collections.singletonList("name:" + serviceInstanceName))).stream().findFirst().map((? super T e) -> CloudFoundryServiceInstance.builder().name(((ServiceInstance)e.getEntity()).getName()).id(e.getMetadata().getGuid()).build()).orElse(null);
    }

    @Nullable
    public CloudFoundrySpace findByName(String orgId, String spaceName) throws CloudFoundryApiException {
        return CloudFoundryClientUtils.collectPages("spaces", page -> this.api.all((Integer)page, spaceName, orgId)).stream().findAny().map(this::map).orElse(null);
    }

    @Nullable
    public CloudFoundryServiceInstance getServiceInstanceByNameAndSpace(String serviceInstanceName, CloudFoundrySpace space) {
        return Optional.ofNullable(this.getServiceInstanceById(space.getId(), serviceInstanceName)).orElse(null);
    }

    private CloudFoundrySpace map(Space space) throws CloudFoundryApiException {
        return CloudFoundrySpace.builder().id(space.getGuid()).name(space.getName()).organization(this.organizations.findById(space.getRelationships().get("organization").getData().getGuid())).build();
    }

    public Optional<CloudFoundrySpace> findSpaceByRegion(String region) {
        CloudFoundrySpace space = CloudFoundrySpace.fromRegion(region);
        CloudFoundryOrganization organization = this.organizations.findByName(space.getOrganization().getName()).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to find organization: " + space.getOrganization().getName()}));
        Optional<CloudFoundrySpace> spaceOptional = CloudFoundryClientUtils.collectPages("spaces", page -> this.api.all((Integer)page, space.getName(), organization.getId())).stream().findAny().map((? super T s) -> CloudFoundrySpace.builder().id(s.getGuid()).name(s.getName()).organization(organization).build());
        spaceOptional.ifPresent(spaceCase -> {
            if (!space.getName().equals(spaceCase.getName()) || !space.getOrganization().getName().equals(spaceCase.getOrganization().getName())) {
                throw new CloudFoundryApiException(new String[]{"Org or Space name not in correct case"});
            }
        });
        return spaceOptional;
    }

    public List<CloudFoundrySpace> findAllBySpaceNamesAndOrgNames(List<String> spaceNames, List<String> orgNames) {
        HashMap allOrgsByGuids = new HashMap();
        this.organizations.findAllByNames(orgNames).stream().forEach(o -> allOrgsByGuids.put(o.getId(), o));
        String spaceNamesQ = spaceNames == null || spaceNames.isEmpty() ? null : String.join((CharSequence)",", spaceNames);
        String orgGuidsQ = allOrgsByGuids.keySet().isEmpty() ? null : String.join((CharSequence)",", allOrgsByGuids.keySet());
        return CloudFoundryClientUtils.collectPages("spaces", page -> this.api.all((Integer)page, spaceNamesQ, orgGuidsQ)).stream().map((? super T s) -> CloudFoundrySpace.builder().organization(allOrgsByGuids.getOrDefault(s.getRelationships().get("organization").getData().getGuid(), null)).name(s.getName()).id(s.getGuid()).build()).filter(s -> s.getOrganization() != null && orgNames.contains(s.getOrganization().getName())).collect(Collectors.toList());
    }

    @Generated
    public Spaces(SpaceService api, Organizations organizations) {
        this.api = api;
        this.organizations = organizations;
    }
}

