/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.Token;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens.AccessTokenProvider;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AccessTokenInterceptor
implements Interceptor {
    private final AccessTokenProvider accessTokenProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Token currentToken = this.accessTokenProvider.getAccessToken();
        if ((currentToken == null || System.currentTimeMillis() >= this.accessTokenProvider.getTokenExpiration()) && this.accessTokenProvider.getRefreshLock().tryLock()) {
            try {
                Token newToken = this.accessTokenProvider.getAccessToken();
                if (currentToken == null || !currentToken.equals(newToken)) {
                    Response response = chain.proceed(this.newRequestWithAccessToken(chain.request(), newToken));
                    return response;
                }
                this.accessTokenProvider.refreshAccessToken();
                Token updatedToken = this.accessTokenProvider.getAccessToken();
                Response response = chain.proceed(this.newRequestWithAccessToken(chain.request(), updatedToken));
                return response;
            }
            finally {
                if (this.accessTokenProvider.getRefreshLock().isHeldByCurrentThread()) {
                    this.accessTokenProvider.getRefreshLock().unlock();
                }
            }
        }
        return chain.proceed(this.newRequestWithAccessToken(chain.request(), currentToken));
    }

    @NonNull
    private Request newRequestWithAccessToken(@NonNull Request request, @NonNull Token token) {
        if (request == null) {
            throw new IllegalArgumentException("request is marked non-null but is null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token is marked non-null but is null");
        }
        return request.newBuilder().header("Authorization", "Bearer " + token.getAccessToken()).build();
    }

    @Generated
    public AccessTokenInterceptor(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }
}

