/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.AuthenticationService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.Token;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;

public class AccessTokenProvider {
    private final String user;
    private final String password;
    private final AuthenticationService uaa;
    private final Object tokenLock = new Object();
    private long tokenExpiration;
    private Token token;
    private ReentrantLock refreshLock = new ReentrantLock();

    public AccessTokenProvider(String user, String password, AuthenticationService uaa) {
        this.user = user;
        this.password = password;
        this.uaa = uaa;
    }

    Token getAccessToken() {
        if (this.token == null) {
            this.refreshAccessToken();
        }
        return this.token;
    }

    void refreshAccessToken() {
        try {
            Token token;
            this.token = token = (Token)CloudFoundryClientUtils.safelyCall(() -> this.uaa.passwordToken("password", this.user, this.password, "cf", "")).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to get authentication token from cloud foundry."}));
            this.tokenExpiration = System.currentTimeMillis() + (token.getExpiresIn() - 120L) * 1000L;
        }
        catch (Exception e) {
            throw new CloudFoundryApiException(e, "Could not refresh token.");
        }
    }

    @Generated
    public Object getTokenLock() {
        return this.tokenLock;
    }

    @Generated
    public long getTokenExpiration() {
        return this.tokenExpiration;
    }

    @Generated
    public ReentrantLock getRefreshLock() {
        return this.refreshLock;
    }
}

