/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.artifacts.ArtifactDownloader;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryServerGroupAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.CreateCloudFoundryServiceBindingDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.CreateCloudFoundryServiceBindingAtomicOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="createServiceBindings")
@Component
public class CreateCloudFoundryServiceBindingAtomicOperationConverter
extends AbstractCloudFoundryServerGroupAtomicOperationConverter {
    private final OperationPoller operationPoller;
    private final ArtifactDownloader artifactDownloader;

    public CreateCloudFoundryServiceBindingAtomicOperationConverter(@Qualifier(value="cloudFoundryOperationPoller") OperationPoller operationPoller, ArtifactDownloader artifactDownloader) {
        this.operationPoller = operationPoller;
        this.artifactDownloader = artifactDownloader;
    }

    @Nullable
    public AtomicOperation convertOperation(Map input) {
        return new CreateCloudFoundryServiceBindingAtomicOperation(this.operationPoller, this.convertDescription(input));
    }

    public CreateCloudFoundryServiceBindingDescription convertDescription(Map input) {
        List requests = (List)input.get("serviceBindingRequests");
        for (Map request : requests) {
            if (request.get("artifact") == null) continue;
            Artifact artifact = (Artifact)this.getObjectMapper().convertValue(request.get("artifact"), Artifact.class);
            try {
                InputStream inputStream = this.artifactDownloader.download(artifact);
                try {
                    Map paramMap = (Map)this.getObjectMapper().readValue(inputStream, Map.class);
                    request.put("parameters", paramMap);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                throw new CloudFoundryApiException(new String[]{"Could not convert service binding request parameters to json."});
            }
        }
        input.put("serviceBindingRequests", requests);
        CreateCloudFoundryServiceBindingDescription description = (CreateCloudFoundryServiceBindingDescription)this.getObjectMapper().convertValue((Object)input, CreateCloudFoundryServiceBindingDescription.class);
        description.setCredentials((CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString()));
        description.setClient(this.getClient(input));
        description.setServerGroupId(this.getServerGroupId(description.getServerGroupName(), description.getRegion(), description.getClient()));
        this.findSpace(description.getRegion(), description.getClient()).ifPresentOrElse(description::setSpace, () -> {
            throw new CloudFoundryApiException(new String[]{"Could not determine CloudFoundry Space."});
        });
        return description;
    }
}

