/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.google.common.collect.Lists;
import com.netflix.spinnaker.clouddriver.artifacts.ArtifactCredentialsRepository;
import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.artifacts.CloudFoundryArtifactCredentials;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.RouteId;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Docker;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessRequest;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryServerGroupAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DeployCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.DeployCloudFoundryServerGroupAtomicOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.util.RandomWordGenerator;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryDomain;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryLoadBalancer;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import io.vavr.API;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="createServerGroup")
@Component
public class DeployCloudFoundryServerGroupAtomicOperationConverter
extends AbstractCloudFoundryServerGroupAtomicOperationConverter {
    private final OperationPoller operationPoller;
    private final ArtifactCredentialsRepository credentialsRepository;
    private final CredentialsRepository<DockerRegistryNamedAccountCredentials> dockerRegistryCredentialsRepository;

    public DeployCloudFoundryServerGroupAtomicOperationConverter(@Qualifier(value="cloudFoundryOperationPoller") OperationPoller operationPoller, ArtifactCredentialsRepository credentialsRepository, CredentialsRepository<DockerRegistryNamedAccountCredentials> dockerRegistryCredentialsRepository) {
        this.operationPoller = operationPoller;
        this.credentialsRepository = credentialsRepository;
        this.dockerRegistryCredentialsRepository = dockerRegistryCredentialsRepository;
    }

    public AtomicOperation convertOperation(Map input) {
        return new DeployCloudFoundryServerGroupAtomicOperation(this.operationPoller, this.convertDescription(input));
    }

    public DeployCloudFoundryServerGroupDescription convertDescription(Map input) {
        DeployCloudFoundryServerGroupDescription converted = (DeployCloudFoundryServerGroupDescription)this.getObjectMapper().convertValue((Object)input, DeployCloudFoundryServerGroupDescription.class);
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        converted.setClient(credentials.getClient());
        converted.setAccountName(credentials.getName());
        String region = converted.getRegion();
        converted.setSpace(this.findSpace(region, converted.getClient()).orElseThrow(() -> new IllegalArgumentException("Unable to find organization and space '" + region + "'.")));
        converted.setArtifactCredentials(this.getArtifactCredentials(converted));
        DeployCloudFoundryServerGroupDescription.ApplicationAttributes applicationAttributes = this.convertManifest(converted.getManifest().stream().findFirst().orElse(Collections.emptyMap()));
        converted.setApplicationAttributes(applicationAttributes);
        converted.setDocker(converted.getArtifactCredentials().getTypes().contains("docker/image") ? this.resolveDockerAccount(converted.getApplicationArtifact()) : null);
        List<String> routes = applicationAttributes.getRoutes();
        if ((routes == null || routes.isEmpty()) && applicationAttributes.getRandomRoute()) {
            this.setRandomRoute(converted);
        }
        return converted;
    }

    private void setRandomRoute(DeployCloudFoundryServerGroupDescription client) {
        CloudFoundryDomain defaultDomain = client.getClient().getDomains().getDefault();
        if (defaultDomain != null) {
            String routeName = null;
            for (int i = 0; i < 10; ++i) {
                routeName = RandomWordGenerator.randomQualifiedNoun() + "." + defaultDomain.getName();
                RouteId routeId = client.getClient().getRoutes().toRouteId(routeName);
                CloudFoundryLoadBalancer cloudFoundryLoadBalancer = client.getClient().getRoutes().find(routeId, client.getSpace().getId());
                if (cloudFoundryLoadBalancer == null) break;
            }
            client.getApplicationAttributes().setRoutes(Lists.newArrayList((Object[])new String[]{routeName}));
        }
    }

    private Docker resolveDockerAccount(Artifact artifact) {
        DockerRegistryNamedAccountCredentials dockerCreds = this.dockerRegistryCredentialsRepository.getAll().stream().filter(reg -> reg.getRegistry().equals(artifact.getReference().split("/")[0])).filter(reg -> reg.getRepositories().contains(artifact.getName().split("/", 2)[1])).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find a docker registry for the docker image: " + artifact.getName()));
        return Docker.builder().image(artifact.getReference()).username(dockerCreds.getUsername()).password(dockerCreds.getPassword()).build();
    }

    private ArtifactCredentials getArtifactCredentials(DeployCloudFoundryServerGroupDescription converted) {
        Artifact artifact = converted.getApplicationArtifact();
        if (artifact == null) {
            throw new IllegalArgumentException("No artifact definition in stage configuration");
        }
        String artifactAccount = artifact.getArtifactAccount();
        if ("cloudfoundry/app".equals(artifact.getType())) {
            CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(artifactAccount);
            String uuid = this.getServerGroupId(artifact.getName(), artifact.getLocation(), credentials.getClient());
            converted.setApplicationArtifact(artifact.toBuilder().uuid(uuid).build());
            return new CloudFoundryArtifactCredentials(credentials.getClient());
        }
        ArtifactCredentials credentials = (ArtifactCredentials)this.credentialsRepository.getFirstCredentialsWithName(artifactAccount);
        if (credentials == null) {
            throw new IllegalArgumentException("Unable to find artifact credentials '" + artifactAccount + "'");
        }
        return credentials;
    }

    DeployCloudFoundryServerGroupDescription.ApplicationAttributes convertManifest(Map<Object, Object> manifestMap) {
        List manifestApps = (List)new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).convertValue(manifestMap.get("applications"), (TypeReference)new TypeReference<List<CloudFoundryManifest>>(){});
        return manifestApps.stream().findFirst().map(app -> {
            List buildpacks = (List)API.Match((Object)app).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(a -> a.getBuildpacks() != null), app.getBuildpacks()), API.Case((API.Match.Pattern0)API.$(a -> a.getBuildpack() != null && a.getBuildpack().length() > 0), Collections.singletonList(app.getBuildpack())), API.Case((API.Match.Pattern0)API.$(), Collections.emptyList())});
            DeployCloudFoundryServerGroupDescription.ApplicationAttributes attrs = new DeployCloudFoundryServerGroupDescription.ApplicationAttributes();
            attrs.setInstances(app.getInstances() == null ? 1 : app.getInstances());
            attrs.setMemory(app.getMemory() == null ? "1024" : app.getMemory());
            attrs.setDiskQuota(app.getDiskQuota() == null ? "1024" : app.getDiskQuota());
            attrs.setHealthCheckHttpEndpoint(app.getHealthCheckHttpEndpoint());
            attrs.setHealthCheckType(app.getHealthCheckType());
            attrs.setBuildpacks(buildpacks);
            attrs.setServices(app.getServices());
            attrs.setRoutes(app.getRoutes() == null ? null : app.getRoutes().stream().flatMap(route -> route.values().stream()).collect(Collectors.toList()));
            attrs.setEnv(app.getEnv());
            attrs.setStack(app.getStack());
            attrs.setCommand(app.getCommand());
            attrs.setProcesses(app.getProcesses());
            attrs.setRandomRoute(app.getRandomRoute());
            attrs.setTimeout(app.getTimeout());
            return attrs;
        }).orElseThrow(() -> new IllegalArgumentException("No app manifest found in Cloud Foundry manifest file"));
    }

    private static class CloudFoundryManifest {
        @Nullable
        private Integer instances;
        @Nullable
        private String memory;
        @Nullable
        @JsonProperty(value="disk_quota")
        private String diskQuota;
        @Nullable
        private String healthCheckType;
        @Nullable
        private String healthCheckHttpEndpoint;
        @Nullable
        private String buildpack;
        @Nullable
        private List<String> buildpacks;
        @Nullable
        private List<String> services;
        @Nullable
        private List<Map<String, String>> routes;
        @Nullable
        private Map<String, String> env;
        @Nullable
        private String stack;
        @Nullable
        private String command;
        @Nullable
        private Boolean randomRoute;
        @Nullable
        private Integer timeout;
        private List<ProcessRequest> processes = Collections.emptyList();

        @Generated
        public CloudFoundryManifest() {
        }

        @Nullable
        @Generated
        public Integer getInstances() {
            return this.instances;
        }

        @Nullable
        @Generated
        public String getMemory() {
            return this.memory;
        }

        @Nullable
        @Generated
        public String getDiskQuota() {
            return this.diskQuota;
        }

        @Nullable
        @Generated
        public String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Nullable
        @Generated
        public String getHealthCheckHttpEndpoint() {
            return this.healthCheckHttpEndpoint;
        }

        @Nullable
        @Generated
        public String getBuildpack() {
            return this.buildpack;
        }

        @Nullable
        @Generated
        public List<String> getBuildpacks() {
            return this.buildpacks;
        }

        @Nullable
        @Generated
        public List<String> getServices() {
            return this.services;
        }

        @Nullable
        @Generated
        public List<Map<String, String>> getRoutes() {
            return this.routes;
        }

        @Nullable
        @Generated
        public Map<String, String> getEnv() {
            return this.env;
        }

        @Nullable
        @Generated
        public String getStack() {
            return this.stack;
        }

        @Nullable
        @Generated
        public String getCommand() {
            return this.command;
        }

        @Nullable
        @Generated
        public Boolean getRandomRoute() {
            return this.randomRoute;
        }

        @Nullable
        @Generated
        public Integer getTimeout() {
            return this.timeout;
        }

        @Generated
        public List<ProcessRequest> getProcesses() {
            return this.processes;
        }

        @Generated
        public CloudFoundryManifest setInstances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        @Generated
        public CloudFoundryManifest setMemory(@Nullable String memory) {
            this.memory = memory;
            return this;
        }

        @JsonProperty(value="disk_quota")
        @Generated
        public CloudFoundryManifest setDiskQuota(@Nullable String diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        @Generated
        public CloudFoundryManifest setHealthCheckType(@Nullable String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        @Generated
        public CloudFoundryManifest setHealthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
            this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
            return this;
        }

        @Generated
        public CloudFoundryManifest setBuildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        @Generated
        public CloudFoundryManifest setBuildpacks(@Nullable List<String> buildpacks) {
            this.buildpacks = buildpacks;
            return this;
        }

        @Generated
        public CloudFoundryManifest setServices(@Nullable List<String> services) {
            this.services = services;
            return this;
        }

        @Generated
        public CloudFoundryManifest setRoutes(@Nullable List<Map<String, String>> routes) {
            this.routes = routes;
            return this;
        }

        @Generated
        public CloudFoundryManifest setEnv(@Nullable Map<String, String> env) {
            this.env = env;
            return this;
        }

        @Generated
        public CloudFoundryManifest setStack(@Nullable String stack) {
            this.stack = stack;
            return this;
        }

        @Generated
        public CloudFoundryManifest setCommand(@Nullable String command) {
            this.command = command;
            return this;
        }

        @Generated
        public CloudFoundryManifest setRandomRoute(@Nullable Boolean randomRoute) {
            this.randomRoute = randomRoute;
            return this;
        }

        @Generated
        public CloudFoundryManifest setTimeout(@Nullable Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public CloudFoundryManifest setProcesses(List<ProcessRequest> processes) {
            this.processes = processes;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CloudFoundryManifest)) {
                return false;
            }
            CloudFoundryManifest other = (CloudFoundryManifest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$instances = this.getInstances();
            Integer other$instances = other.getInstances();
            if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
                return false;
            }
            Boolean this$randomRoute = this.getRandomRoute();
            Boolean other$randomRoute = other.getRandomRoute();
            if (this$randomRoute == null ? other$randomRoute != null : !((Object)this$randomRoute).equals(other$randomRoute)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            String this$memory = this.getMemory();
            String other$memory = other.getMemory();
            if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) {
                return false;
            }
            String this$diskQuota = this.getDiskQuota();
            String other$diskQuota = other.getDiskQuota();
            if (this$diskQuota == null ? other$diskQuota != null : !this$diskQuota.equals(other$diskQuota)) {
                return false;
            }
            String this$healthCheckType = this.getHealthCheckType();
            String other$healthCheckType = other.getHealthCheckType();
            if (this$healthCheckType == null ? other$healthCheckType != null : !this$healthCheckType.equals(other$healthCheckType)) {
                return false;
            }
            String this$healthCheckHttpEndpoint = this.getHealthCheckHttpEndpoint();
            String other$healthCheckHttpEndpoint = other.getHealthCheckHttpEndpoint();
            if (this$healthCheckHttpEndpoint == null ? other$healthCheckHttpEndpoint != null : !this$healthCheckHttpEndpoint.equals(other$healthCheckHttpEndpoint)) {
                return false;
            }
            String this$buildpack = this.getBuildpack();
            String other$buildpack = other.getBuildpack();
            if (this$buildpack == null ? other$buildpack != null : !this$buildpack.equals(other$buildpack)) {
                return false;
            }
            List<String> this$buildpacks = this.getBuildpacks();
            List<String> other$buildpacks = other.getBuildpacks();
            if (this$buildpacks == null ? other$buildpacks != null : !((Object)this$buildpacks).equals(other$buildpacks)) {
                return false;
            }
            List<String> this$services = this.getServices();
            List<String> other$services = other.getServices();
            if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
                return false;
            }
            List<Map<String, String>> this$routes = this.getRoutes();
            List<Map<String, String>> other$routes = other.getRoutes();
            if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
                return false;
            }
            Map<String, String> this$env = this.getEnv();
            Map<String, String> other$env = other.getEnv();
            if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
                return false;
            }
            String this$stack = this.getStack();
            String other$stack = other.getStack();
            if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            List<ProcessRequest> this$processes = this.getProcesses();
            List<ProcessRequest> other$processes = other.getProcesses();
            return !(this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CloudFoundryManifest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $instances = this.getInstances();
            result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
            Boolean $randomRoute = this.getRandomRoute();
            result = result * 59 + ($randomRoute == null ? 43 : ((Object)$randomRoute).hashCode());
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            String $memory = this.getMemory();
            result = result * 59 + ($memory == null ? 43 : $memory.hashCode());
            String $diskQuota = this.getDiskQuota();
            result = result * 59 + ($diskQuota == null ? 43 : $diskQuota.hashCode());
            String $healthCheckType = this.getHealthCheckType();
            result = result * 59 + ($healthCheckType == null ? 43 : $healthCheckType.hashCode());
            String $healthCheckHttpEndpoint = this.getHealthCheckHttpEndpoint();
            result = result * 59 + ($healthCheckHttpEndpoint == null ? 43 : $healthCheckHttpEndpoint.hashCode());
            String $buildpack = this.getBuildpack();
            result = result * 59 + ($buildpack == null ? 43 : $buildpack.hashCode());
            List<String> $buildpacks = this.getBuildpacks();
            result = result * 59 + ($buildpacks == null ? 43 : ((Object)$buildpacks).hashCode());
            List<String> $services = this.getServices();
            result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
            List<Map<String, String>> $routes = this.getRoutes();
            result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
            Map<String, String> $env = this.getEnv();
            result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
            String $stack = this.getStack();
            result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            List<ProcessRequest> $processes = this.getProcesses();
            result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DeployCloudFoundryServerGroupAtomicOperationConverter.CloudFoundryManifest(instances=" + this.getInstances() + ", memory=" + this.getMemory() + ", diskQuota=" + this.getDiskQuota() + ", healthCheckType=" + this.getHealthCheckType() + ", healthCheckHttpEndpoint=" + this.getHealthCheckHttpEndpoint() + ", buildpack=" + this.getBuildpack() + ", buildpacks=" + this.getBuildpacks() + ", services=" + this.getServices() + ", routes=" + this.getRoutes() + ", env=" + this.getEnv() + ", stack=" + this.getStack() + ", command=" + this.getCommand() + ", randomRoute=" + this.getRandomRoute() + ", timeout=" + this.getTimeout() + ", processes=" + this.getProcesses() + ")";
        }
    }
}

