/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ServiceInstanceResponse;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.LastOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DeployCloudFoundryServiceDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import lombok.Generated;

public class DeployCloudFoundryServiceAtomicOperation
implements AtomicOperation<ServiceInstanceResponse> {
    private static final String PHASE = "DEPLOY_SERVICE";
    private final DeployCloudFoundryServiceDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public ServiceInstanceResponse operate(List priorOutputs) {
        ServiceInstanceResponse serviceInstanceResponse;
        Task task = DeployCloudFoundryServiceAtomicOperation.getTask();
        if (!this.description.isUserProvided()) {
            DeployCloudFoundryServiceDescription.ServiceAttributes serviceAttributes = this.description.getServiceAttributes();
            String serviceInstanceName = serviceAttributes.getServiceInstanceName();
            serviceInstanceResponse = this.description.getClient().getServiceInstances().createServiceInstance(serviceInstanceName, serviceAttributes.getService(), serviceAttributes.getServicePlan(), serviceAttributes.getTags(), serviceAttributes.getParameterMap(), serviceAttributes.isUpdatable(), this.description.getSpace());
            String gerund = serviceInstanceResponse.getType() == LastOperation.Type.UPDATE ? "Updating" : "Creating";
            serviceInstanceResponse.setPreviousInstanceName(serviceAttributes.getPreviousInstanceName());
            task.updateStatus(PHASE, gerund + " service instance '" + serviceInstanceName + "' from service " + serviceAttributes.getService() + " and service plan " + serviceAttributes.getServicePlan());
        } else {
            DeployCloudFoundryServiceDescription.UserProvidedServiceAttributes userProvidedServiceAttributes = this.description.getUserProvidedServiceAttributes();
            String serviceInstanceName = userProvidedServiceAttributes.getServiceInstanceName();
            task.updateStatus(PHASE, "Creating user-provided service instance '" + serviceInstanceName + "'");
            serviceInstanceResponse = this.description.getClient().getServiceInstances().createUserProvidedServiceInstance(serviceInstanceName, userProvidedServiceAttributes.getSyslogDrainUrl(), userProvidedServiceAttributes.getTags(), userProvidedServiceAttributes.getCredentials(), userProvidedServiceAttributes.getRouteServiceUrl(), userProvidedServiceAttributes.isUpdatable(), this.description.getSpace());
            String verb = serviceInstanceResponse.getType() == LastOperation.Type.UPDATE ? "Updated" : "Created";
            serviceInstanceResponse.setPreviousInstanceName(userProvidedServiceAttributes.getPreviousInstanceName());
            task.updateStatus(PHASE, verb + " user-provided service instance '" + serviceInstanceName + "'");
        }
        return serviceInstanceResponse;
    }

    @Generated
    public DeployCloudFoundryServiceAtomicOperation(DeployCloudFoundryServiceDescription description) {
        this.description = description;
    }
}

