/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.TerminateCloudFoundryInstancesDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class TerminateCloudFoundryInstancesAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "TERMINATE_INSTANCES";
    private final TerminateCloudFoundryInstancesDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        TerminateCloudFoundryInstancesAtomicOperation.getTask().updateStatus(PHASE, "Terminating " + this.instanceDescription());
        CloudFoundryClient client = this.description.getClient();
        for (String instance : this.description.getInstanceIds()) {
            try {
                String serverGroupId = instance.substring(0, instance.lastIndexOf("-"));
                String instanceIndex = instance.substring(instance.lastIndexOf("-") + 1);
                client.getApplications().deleteAppInstance(serverGroupId, instanceIndex);
                TerminateCloudFoundryInstancesAtomicOperation.getTask().updateStatus(PHASE, "Terminated " + this.instanceDescription());
            }
            catch (CloudFoundryApiException e) {
                throw new CloudFoundryApiException(new String[]{"Failed to terminate '" + instance + "': " + e.getMessage()});
            }
        }
        return null;
    }

    private String instanceDescription() {
        return this.description.getInstanceIds().length == 1 ? "application instance '" + this.description.getInstanceIds()[0] + "'" : "application instances [" + Arrays.stream(this.description.getInstanceIds()).map(id -> "'" + id + "'").collect(Collectors.joining(", ")) + "]";
    }

    @Generated
    public TerminateCloudFoundryInstancesAtomicOperation(TerminateCloudFoundryInstancesDescription description) {
        this.description = description;
    }
}

