/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Task;
import com.netflix.spinnaker.clouddriver.model.JobState;
import com.netflix.spinnaker.clouddriver.model.JobStatus;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonDeserialize(builder=CloudFoundryJobStatusBuilder.class)
public class CloudFoundryJobStatus
implements JobStatus {
    @Nullable
    private String name;
    private String account;
    private String id;
    private String location;
    private final String provider = CloudFoundryCloudProvider.ID;
    private JobState jobState;
    private Long createdTime;
    @Nullable
    private Long completedTime;

    public Map<String, ? extends Serializable> getCompletionDetails() {
        return Collections.emptyMap();
    }

    public static CloudFoundryJobStatus fromTask(Task task, String account, String location) {
        Task.State state = task.getState();
        CloudFoundryJobStatusBuilder builder = CloudFoundryJobStatus.builder();
        switch (state) {
            case FAILED: {
                builder.jobState(JobState.Failed);
                builder.completedTime(task.getUpdatedAt().toInstant().toEpochMilli());
                break;
            }
            case RUNNING: {
                builder.jobState(JobState.Running);
                break;
            }
            case SUCCEEDED: {
                builder.jobState(JobState.Succeeded);
                builder.completedTime(task.getUpdatedAt().toInstant().toEpochMilli());
                break;
            }
            default: {
                builder.jobState(JobState.Unknown);
            }
        }
        return builder.name(task.getName()).account(account).id(task.getGuid()).location(location).createdTime(task.getCreatedAt().toInstant().toEpochMilli()).build();
    }

    @Generated
    CloudFoundryJobStatus(@Nullable String name, String account, String id, String location, JobState jobState, Long createdTime, @Nullable Long completedTime) {
        this.name = name;
        this.account = account;
        this.id = id;
        this.location = location;
        this.jobState = jobState;
        this.createdTime = createdTime;
        this.completedTime = completedTime;
    }

    @Generated
    public static CloudFoundryJobStatusBuilder builder() {
        return new CloudFoundryJobStatusBuilder();
    }

    @Nullable
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public JobState getJobState() {
        return this.jobState;
    }

    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Nullable
    @Generated
    public Long getCompletedTime() {
        return this.completedTime;
    }

    @Generated
    public CloudFoundryJobStatus setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Generated
    public CloudFoundryJobStatus setAccount(String account) {
        this.account = account;
        return this;
    }

    @Generated
    public CloudFoundryJobStatus setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public CloudFoundryJobStatus setLocation(String location) {
        this.location = location;
        return this;
    }

    @Generated
    public CloudFoundryJobStatus setJobState(JobState jobState) {
        this.jobState = jobState;
        return this;
    }

    @Generated
    public CloudFoundryJobStatus setCreatedTime(Long createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Generated
    public CloudFoundryJobStatus setCompletedTime(@Nullable Long completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    @Generated
    public String toString() {
        return "CloudFoundryJobStatus(name=" + this.getName() + ", account=" + this.getAccount() + ", id=" + this.getId() + ", location=" + this.getLocation() + ", provider=" + this.getProvider() + ", jobState=" + this.getJobState() + ", createdTime=" + this.getCreatedTime() + ", completedTime=" + this.getCompletedTime() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudFoundryJobStatus)) {
            return false;
        }
        CloudFoundryJobStatus other = (CloudFoundryJobStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$createdTime = this.getCreatedTime();
        Long other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Long this$completedTime = this.getCompletedTime();
        Long other$completedTime = other.getCompletedTime();
        if (this$completedTime == null ? other$completedTime != null : !((Object)this$completedTime).equals(other$completedTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        JobState this$jobState = this.getJobState();
        JobState other$jobState = other.getJobState();
        return !(this$jobState == null ? other$jobState != null : !this$jobState.equals(other$jobState));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudFoundryJobStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Long $completedTime = this.getCompletedTime();
        result = result * 59 + ($completedTime == null ? 43 : ((Object)$completedTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        JobState $jobState = this.getJobState();
        result = result * 59 + ($jobState == null ? 43 : $jobState.hashCode());
        return result;
    }

    @Generated
    public static class CloudFoundryJobStatusBuilder {
        @Generated
        private String name;
        @Generated
        private String account;
        @Generated
        private String id;
        @Generated
        private String location;
        @Generated
        private JobState jobState;
        @Generated
        private Long createdTime;
        @Generated
        private Long completedTime;

        @Generated
        CloudFoundryJobStatusBuilder() {
        }

        @Generated
        public CloudFoundryJobStatusBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Generated
        public CloudFoundryJobStatusBuilder account(String account) {
            this.account = account;
            return this;
        }

        @Generated
        public CloudFoundryJobStatusBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public CloudFoundryJobStatusBuilder location(String location) {
            this.location = location;
            return this;
        }

        @Generated
        public CloudFoundryJobStatusBuilder jobState(JobState jobState) {
            this.jobState = jobState;
            return this;
        }

        @Generated
        public CloudFoundryJobStatusBuilder createdTime(Long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public CloudFoundryJobStatusBuilder completedTime(@Nullable Long completedTime) {
            this.completedTime = completedTime;
            return this;
        }

        @Generated
        public CloudFoundryJobStatus build() {
            return new CloudFoundryJobStatus(this.name, this.account, this.id, this.location, this.jobState, this.createdTime, this.completedTime);
        }

        @Generated
        public String toString() {
            return "CloudFoundryJobStatus.CloudFoundryJobStatusBuilder(name=" + this.name + ", account=" + this.account + ", id=" + this.id + ", location=" + this.location + ", jobState=" + this.jobState + ", createdTime=" + this.createdTime + ", completedTime=" + this.completedTime + ")";
        }
    }
}

