/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.view;

import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.CacheRepository;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryApplication;
import com.netflix.spinnaker.clouddriver.model.Application;
import com.netflix.spinnaker.clouddriver.model.ApplicationProvider;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryApplicationProvider
implements ApplicationProvider {
    private final Cache cacheView;
    private final CacheRepository repository;

    public Set<? extends Application> getApplications(boolean expand) {
        return this.repository.findApplicationsByKeys(this.cacheView.filterIdentifiers(Keys.Namespace.APPLICATIONS.getNs(), Keys.getApplicationKey("*")), expand ? CacheRepository.Detail.NAMES_ONLY : CacheRepository.Detail.NONE);
    }

    @Nullable
    public CloudFoundryApplication getApplication(String name) {
        return this.repository.findApplicationByKey(Keys.getApplicationKey(name), CacheRepository.Detail.NAMES_ONLY).orElse(null);
    }

    @Generated
    public CloudFoundryApplicationProvider(Cache cacheView, CacheRepository repository) {
        this.cacheView = cacheView;
        this.repository = repository;
    }
}

