/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ErrorDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Page;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Pagination;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public final class CloudFoundryClientUtils {
    private static final String BINDING_NAME_INVALID_CHARACTER_PATTERN = "[^\\w-]+";
    private static final ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Optional<T> safelyCall(Supplier<Call<T>> r) {
        Response response = null;
        try {
            response = r.get().execute();
            if (response == null) return Optional.ofNullable(response.body());
        }
        catch (Exception e) {
            try {
                throw new CloudFoundryApiException(e, new String[0]);
            }
            catch (Throwable throwable) {
                if (response == null) throw throwable;
                if (response.isSuccessful()) throw throwable;
                try (ResponseBody responseBody2 = response.errorBody();){
                    if (response.code() == 401) {
                        throw new CloudFoundryApiException(new String[]{"Unauthorized"});
                    }
                    if (response.code() == 404) {
                        Optional optional = Optional.empty();
                        return optional;
                    }
                    ErrorDescription errorDescription = (ErrorDescription)mapper.readValue(responseBody2.string(), ErrorDescription.class);
                    throw new CloudFoundryApiException(errorDescription);
                }
                catch (IOException e2) {
                    throw new CloudFoundryApiException(e2, "Could not parse error");
                }
            }
        }
        if (response.isSuccessful()) return Optional.ofNullable(response.body());
        try (ResponseBody responseBody = response.errorBody();){
            if (response.code() == 401) {
                throw new CloudFoundryApiException(new String[]{"Unauthorized"});
            }
            if (response.code() == 404) {
                Optional optional = Optional.empty();
                return optional;
            }
            ErrorDescription errorDescription = (ErrorDescription)mapper.readValue(responseBody.string(), ErrorDescription.class);
            throw new CloudFoundryApiException(errorDescription);
        }
        catch (IOException e) {
            throw new CloudFoundryApiException(e, "Could not parse error");
        }
    }

    static <R> List<R> collectPages(String resourceNamePluralized, Function<Integer, Call<Pagination<R>>> fetchPage) throws CloudFoundryApiException {
        Pagination firstPage = (Pagination)CloudFoundryClientUtils.safelyCall(() -> (Call)fetchPage.apply(null)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to retrieve " + resourceNamePluralized}));
        ArrayList allResources = new ArrayList(firstPage.getResources());
        int page = 2;
        while (page <= firstPage.getPagination().getTotalPages()) {
            int p = page++;
            allResources.addAll(((Pagination)CloudFoundryClientUtils.safelyCall(() -> (Call)fetchPage.apply(p)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to retrieve " + resourceNamePluralized}))).getResources());
        }
        return allResources;
    }

    static <R> List<Resource<R>> collectPageResources(String resourceNamePluralized, Function<Integer, Call<Page<R>>> fetchPage) throws CloudFoundryApiException {
        Page firstPage = (Page)CloudFoundryClientUtils.safelyCall(() -> (Call)fetchPage.apply(null)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to retrieve " + resourceNamePluralized}));
        ArrayList allResources = new ArrayList(firstPage.getResources());
        int page = 2;
        while (page <= firstPage.getTotalPages()) {
            int p = page++;
            allResources.addAll(((Page)CloudFoundryClientUtils.safelyCall(() -> (Call)fetchPage.apply(p)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to retrieve " + resourceNamePluralized}))).getResources());
        }
        return allResources;
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static String convertToValidServiceBindingName(String name) {
        return name.replaceAll(BINDING_NAME_INVALID_CHARACTER_PATTERN, "-");
    }
}

