/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.TaskService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateTask;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Task;
import lombok.Generated;

public class Tasks {
    private final TaskService api;

    public Task createTask(String applicationGuid, String command, String name) {
        CreateTask createTask = CreateTask.builder().command(command).name(name).build();
        return (Task)CloudFoundryClientUtils.safelyCall(() -> this.api.createTask(applicationGuid, createTask)).orElseThrow(ResourceNotFoundException::new);
    }

    public Task getTask(String id) {
        return (Task)CloudFoundryClientUtils.safelyCall(() -> this.api.getTask(id)).orElseThrow(ResourceNotFoundException::new);
    }

    public Task cancelTask(String id) {
        return (Task)CloudFoundryClientUtils.safelyCall(() -> this.api.cancelTask(id, "")).orElseThrow(ResourceNotFoundException::new);
    }

    @Generated
    public Tasks(TaskService api) {
        this.api = api;
    }
}

