/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider;

import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.clouddriver.cache.SearchableProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.security.BaseProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;

public class CloudFoundryProvider
extends BaseProvider
implements SearchableProvider {
    private final Set<String> defaultCaches = Stream.of(Keys.Namespace.APPLICATIONS.getNs(), Keys.Namespace.CLUSTERS.getNs(), Keys.Namespace.SERVER_GROUPS.getNs(), Keys.Namespace.INSTANCES.getNs(), Keys.Namespace.LOAD_BALANCERS.getNs(), Keys.Namespace.SPACES.getNs()).collect(Collectors.toSet());
    private final Map<SearchableProvider.SearchableResource, SearchableProvider.SearchResultHydrator> searchResultHydrators = Collections.singletonMap(new SearchableProvider.SearchableResource(Keys.Namespace.APPLICATIONS.getNs(), "cloudfoundry"), new ApplicationSearchResultHydrator());
    private final Map<String, String> urlMappingTemplates = Collections.emptyMap();
    public static final String PROVIDER_ID = "cloudfoundry";
    private final String providerName = CloudFoundryProvider.class.getName();

    @Nullable
    public Map<String, String> parseKey(String key) {
        return Keys.parse(key).orElse(null);
    }

    @Generated
    public CloudFoundryProvider() {
    }

    @Generated
    public Set<String> getDefaultCaches() {
        return this.defaultCaches;
    }

    @Generated
    public Map<SearchableProvider.SearchableResource, SearchableProvider.SearchResultHydrator> getSearchResultHydrators() {
        return this.searchResultHydrators;
    }

    @Generated
    public Map<String, String> getUrlMappingTemplates() {
        return this.urlMappingTemplates;
    }

    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    static class ApplicationSearchResultHydrator
    implements SearchableProvider.SearchResultHydrator {
        ApplicationSearchResultHydrator() {
        }

        public Map<String, String> hydrateResult(Cache cacheView, Map<String, String> result, String id) {
            result.put("application", result.get("name"));
            return result;
        }
    }
}

