/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.ResourceCacheData;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.CloudFoundryProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import io.vavr.collection.HashMap;
import java.io.IOException;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCloudFoundryCachingAgent
implements CachingAgent,
OnDemandAgent,
AccountAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCloudFoundryCachingAgent.class);
    private final String providerName = CloudFoundryProvider.class.getName();
    private static final ObjectMapper cacheViewMapper = new ObjectMapper().disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    private final OnDemandMetricsSupport metricsSupport;
    private final Clock internalClock;
    private final CloudFoundryCredentials credentials;

    AbstractCloudFoundryCachingAgent(CloudFoundryCredentials credentials, Registry registry) {
        this(credentials, registry, Clock.systemDefaultZone());
    }

    private AbstractCloudFoundryCachingAgent(CloudFoundryCredentials credentials, Registry registry, Clock internalClock) {
        this.credentials = credentials;
        cacheViewMapper.setConfig(cacheViewMapper.getSerializationConfig().withView(Views.Cache.class));
        this.metricsSupport = new OnDemandMetricsSupport(registry, (OnDemandAgent)this, "cloudfoundry:" + OnDemandType.ServerGroup);
        this.internalClock = internalClock;
    }

    public String getAccountName() {
        return this.credentials.getName();
    }

    public String getAgentType() {
        return this.getAccountName() + "/" + this.getClass().getSimpleName();
    }

    public String getOnDemandAgentType() {
        return this.getAgentType() + "-OnDemand";
    }

    public OnDemandMetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }

    static Map<String, Object> cacheView(Object o) {
        return Collections.singletonMap("resource", cacheViewMapper.convertValue(o, (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    protected CloudFoundryClient getClient() {
        return this.credentials.getClient();
    }

    Map<String, Collection<ResourceCacheData>> getCacheResultsFromCacheData(CacheData cacheData) {
        try {
            return (Map)cacheViewMapper.readValue(cacheData.getAttributes().get("cacheResults").toString(), (TypeReference)new TypeReference<Map<String, Collection<ResourceCacheData>>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize cache results", e);
        }
    }

    void processOnDemandCacheData(CacheData cacheData) {
        Map attributes = cacheData.getAttributes();
        attributes.put("processedTime", System.currentTimeMillis());
        attributes.put("processedCount", attributes.getOrDefault("processedCount", 0) + 1);
    }

    CacheData buildOnDemandCacheData(String key, Map<String, Collection<CacheData>> cacheResult) {
        try {
            return new DefaultCacheData(key, (int)TimeUnit.MINUTES.toSeconds(10L), (Map)HashMap.of((Object)"cacheTime", (Object)this.getInternalClock().instant().toEpochMilli(), (Object)"cacheResults", (Object)cacheViewMapper.writeValueAsString(cacheResult), (Object)"processedCount", (Object)0).toJavaMap(), Collections.emptyMap(), this.getInternalClock());
        }
        catch (JsonProcessingException serializationException) {
            throw new RuntimeException("cache results serialization failed", serializationException);
        }
    }

    @Generated
    public String getProviderName() {
        return this.providerName;
    }

    @Generated
    public Clock getInternalClock() {
        return this.internalClock;
    }

    @Generated
    public CloudFoundryCredentials getCredentials() {
        return this.credentials;
    }
}

