/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.clouddriver.cloudfoundry.config.CloudFoundryConfigurationProperties;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableConfigurationProperties
@EnableScheduling
@ConditionalOnProperty(value={"cloudfoundry.enabled"})
@ComponentScan(value={"com.netflix.spinnaker.clouddriver.cloudfoundry"})
public class CloudFoundryConfiguration {
    @Bean
    @RefreshScope
    CloudFoundryConfigurationProperties cloudFoundryConfigurationProperties() {
        return new CloudFoundryConfigurationProperties();
    }

    @Bean
    OperationPoller cloudFoundryOperationPoller(CloudFoundryConfigurationProperties properties) {
        return new OperationPoller(properties.getAsyncOperationTimeoutMillisecondsDefault(), properties.getAsyncOperationMaxPollingIntervalMilliseconds());
    }
}

