/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.cats.agent.AgentScheduler;
import com.netflix.spinnaker.cats.cluster.AgentIntervalProvider;
import com.netflix.spinnaker.cats.cluster.DefaultNodeIdentity;
import com.netflix.spinnaker.cats.cluster.NodeIdentity;
import com.netflix.spinnaker.cats.cluster.NodeStatusProvider;
import com.netflix.spinnaker.cats.cluster.ShardingFilter;
import com.netflix.spinnaker.cats.redis.cluster.ClusteredAgentScheduler;
import com.netflix.spinnaker.cats.redis.cluster.ClusteredSortAgentScheduler;
import com.netflix.spinnaker.clouddriver.core.RedisConfigurationProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import java.net.URI;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;

@Configuration
@ConditionalOnProperty(value={"caching.write-enabled"}, matchIfMissing=true)
public class AgentSchedulerConfig {
    @Bean
    @ConditionalOnExpression(value="${redis.enabled:true} && ${redis.scheduler.enabled:true}")
    AgentScheduler redisAgentScheduler(RedisConfigurationProperties redisConfigurationProperties, RedisClientDelegate redisClientDelegate, JedisPool jedisPool, AgentIntervalProvider agentIntervalProvider, NodeStatusProvider nodeStatusProvider, DynamicConfigService dynamicConfigService, ShardingFilter shardingFilter) {
        if (redisConfigurationProperties.getScheduler().equalsIgnoreCase("default")) {
            URI redisUri = URI.create(redisConfigurationProperties.getConnection());
            String redisHost = redisUri.getHost();
            int redisPort = redisUri.getPort();
            if (redisPort == -1) {
                redisPort = 6379;
            }
            return new ClusteredAgentScheduler(redisClientDelegate, (NodeIdentity)new DefaultNodeIdentity(redisHost, redisPort), agentIntervalProvider, nodeStatusProvider, redisConfigurationProperties.getAgent().getEnabledPattern(), redisConfigurationProperties.getAgent().getAgentLockAcquisitionIntervalSeconds(), dynamicConfigService, shardingFilter);
        }
        if (redisConfigurationProperties.getScheduler().equalsIgnoreCase("sort")) {
            return new ClusteredSortAgentScheduler(jedisPool, nodeStatusProvider, agentIntervalProvider, Integer.valueOf(redisConfigurationProperties.getParallelism()));
        }
        throw new IllegalStateException("redis.scheduler must be one of 'default', 'sort', or ''.");
    }
}

