/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentLock;
import com.netflix.spinnaker.cats.agent.AgentScheduler;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.module.CatsModule;
import com.netflix.spinnaker.cats.provider.Provider;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandCacheResult;
import com.netflix.spinnaker.clouddriver.cache.OnDemandCacheStatus;
import com.netflix.spinnaker.clouddriver.cache.OnDemandCacheUpdater;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CatsOnDemandCacheUpdater
implements OnDemandCacheUpdater {
    private static final Logger log = LoggerFactory.getLogger(CatsOnDemandCacheUpdater.class);
    private final List<Provider> providers;
    private final CatsModule catsModule;
    private final AgentScheduler agentScheduler;

    @Autowired
    public CatsOnDemandCacheUpdater(List<Provider> providers, CatsModule catsModule, AgentScheduler<? extends AgentLock> agentScheduler) {
        this.providers = providers;
        this.catsModule = catsModule;
        this.agentScheduler = agentScheduler;
    }

    private Collection<OnDemandAgent> getOnDemandAgents() {
        return this.providers.stream().flatMap(provider -> provider.getAgents().stream().filter(it -> it instanceof OnDemandAgent)).map(it -> (OnDemandAgent)it).collect(Collectors.toList());
    }

    @Override
    public boolean handles(OnDemandType type, String cloudProvider) {
        return this.getOnDemandAgents().stream().anyMatch(it -> it.handles(type, cloudProvider));
    }

    @Override
    public OnDemandCacheResult handle(OnDemandType type, String cloudProvider, Map<String, ?> data) {
        return this.handle(type, this.onDemandAgents(type, cloudProvider), data);
    }

    private OnDemandCacheResult handle(OnDemandType type, Collection<OnDemandAgent> onDemandAgents, Map<String, ?> data) {
        log.debug("Calling handle onDemandAgents: {}, type: {}", onDemandAgents, (Object)type);
        boolean hasOnDemandResults = false;
        HashMap<String, List<String>> cachedIdentifiersByType = new HashMap<String, List<String>>();
        for (OnDemandAgent agent : onDemandAgents) {
            try {
                OnDemandAgent.OnDemandResult result;
                AgentLock lock = this.agentScheduler.tryLock((Agent)agent);
                if (this.agentScheduler.isAtomic() && lock == null) {
                    hasOnDemandResults = true;
                    continue;
                }
                long startTime = System.nanoTime();
                ProviderCache providerCache = this.catsModule.getProviderRegistry().getProviderCache(agent.getProviderName());
                if (agent.getMetricsSupport() != null) {
                    agent.getMetricsSupport().countOnDemand();
                }
                if ((result = agent.handle(providerCache, data)) == null) continue;
                if (this.agentScheduler.isAtomic() && !this.agentScheduler.lockValid(lock)) {
                    hasOnDemandResults = true;
                    continue;
                }
                if (agent.getMetricsSupport() == null) continue;
                if (result.getCacheResult() != null) {
                    Map results = result.getCacheResult().getCacheResults();
                    if (this.agentHasOnDemandResults(results)) {
                        hasOnDemandResults = true;
                        results.forEach((k, v) -> {
                            if (v != null && !v.isEmpty()) {
                                if (!cachedIdentifiersByType.containsKey(k)) {
                                    cachedIdentifiersByType.put((String)k, new ArrayList());
                                }
                                ((List)cachedIdentifiersByType.get(k)).addAll(v.stream().map(CacheData::getId).collect(Collectors.toList()));
                            }
                        });
                    }
                    agent.getMetricsSupport().cacheWrite(() -> {
                        if (result.cacheResult.isPartialResult()) {
                            providerCache.addCacheResult(result.sourceAgentType, result.authoritativeTypes, result.cacheResult);
                        } else {
                            providerCache.putCacheResult(result.sourceAgentType, result.authoritativeTypes, result.cacheResult);
                        }
                    });
                }
                if (result.getEvictions() != null && !result.getEvictions().isEmpty()) {
                    agent.getMetricsSupport().cacheEvict(() -> result.evictions.forEach((arg_0, arg_1) -> ((ProviderCache)providerCache).evictDeletedItems(arg_0, arg_1)));
                }
                if (this.agentScheduler.isAtomic() && !this.agentScheduler.tryRelease(lock)) {
                    throw new IllegalStateException("We likely just wrote stale data. If you're seeing this, file a github issue: https://github.com/spinnaker/spinnaker/issues");
                }
                long elapsed = System.nanoTime() - startTime;
                agent.getMetricsSupport().recordTotalRunTimeNanos(elapsed);
                log.info("{}/{} handled {} in {}ms.", new Object[]{agent.getProviderName(), agent.getOnDemandAgentType(), type, TimeUnit.NANOSECONDS.toMillis(elapsed)});
            }
            catch (Exception e) {
                if (agent.getMetricsSupport() != null) {
                    agent.getMetricsSupport().countError();
                }
                log.warn("{}/{} failed to handle on demand update for {}", new Object[]{agent.getProviderName(), agent.getOnDemandAgentType(), type, e});
            }
        }
        if (hasOnDemandResults) {
            return new OnDemandCacheResult(OnDemandCacheStatus.PENDING, cachedIdentifiersByType);
        }
        return new OnDemandCacheResult(OnDemandCacheStatus.SUCCESSFUL);
    }

    private boolean agentHasOnDemandResults(Map<String, Collection<CacheData>> results) {
        return !this.agentScheduler.isAtomic() && Optional.ofNullable(results).orElseGet(HashMap::new).values().stream().mapToLong(Collection::size).sum() != 0L;
    }

    @Override
    public Collection<Map<String, Object>> pendingOnDemandRequests(OnDemandType type, String cloudProvider) {
        if (this.agentScheduler.isAtomic()) {
            return new ArrayList<Map<String, Object>>();
        }
        return this.onDemandAgentStream(type, cloudProvider).flatMap(it -> {
            ProviderCache providerCache = this.catsModule.getProviderRegistry().getProviderCache(it.getProviderName());
            return it.pendingOnDemandRequests(providerCache).stream();
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> pendingOnDemandRequest(OnDemandType type, String cloudProvider, String id) {
        if (this.agentScheduler.isAtomic()) {
            return null;
        }
        return this.onDemandAgentStream(type, cloudProvider).map(it -> {
            ProviderCache providerCache = this.catsModule.getProviderRegistry().getProviderCache(it.getProviderName());
            return it.pendingOnDemandRequest(providerCache, id);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Stream<OnDemandAgent> onDemandAgentStream(OnDemandType type, String cloudProvider) {
        return this.getOnDemandAgents().stream().filter(it -> it.handles(type, cloudProvider));
    }

    private Collection<OnDemandAgent> onDemandAgents(OnDemandType type, String cloudProvider) {
        return this.onDemandAgentStream(type, cloudProvider).collect(Collectors.toList());
    }
}

