/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.cluster.AgentIntervalProvider;
import com.netflix.spinnaker.cats.cluster.DefaultAgentIntervalProvider;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;

public class CustomSchedulableAgentIntervalProvider
extends DefaultAgentIntervalProvider {
    public CustomSchedulableAgentIntervalProvider(long interval, long errorInterval, long timeout) {
        super(interval, errorInterval, timeout);
    }

    public AgentIntervalProvider.Interval getInterval(Agent agent) {
        if (agent instanceof CustomScheduledAgent) {
            CustomScheduledAgent customAgent = (CustomScheduledAgent)agent;
            return this.getCustomInterval(customAgent);
        }
        return super.getInterval(agent);
    }

    AgentIntervalProvider.Interval getCustomInterval(CustomScheduledAgent agent) {
        long pollInterval = agent.getPollIntervalMillis() == -1L ? super.getInterval() : agent.getPollIntervalMillis();
        long errorInterval = agent.getErrorIntervalMillis() == -1L ? super.getErrorInterval() : agent.getErrorIntervalMillis();
        long timeoutMillis = agent.getTimeoutMillis() == -1L ? super.getTimeout() : agent.getTimeoutMillis();
        return new AgentIntervalProvider.Interval(pollInterval, errorInterval, timeoutMillis);
    }
}

