/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.NamedCacheFactory;
import com.netflix.spinnaker.cats.redis.cache.RedisCache;
import com.netflix.spinnaker.cats.redis.cache.RedisCacheOptions;
import com.netflix.spinnaker.cats.redis.cache.RedisNamedCacheFactory;
import com.netflix.spinnaker.clouddriver.core.RedisConfigurationProperties;
import com.netflix.spinnaker.kork.jedis.JedisClientDelegate;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.Pool;

@Configuration
@ConditionalOnExpression(value="${redis.enabled:true} && ${redis.cache.enabled:true}")
@EnableConfigurationProperties(value={RedisConfigurationProperties.class})
class JedisCacheConfig {
    JedisCacheConfig() {
    }

    @Bean
    RedisClientDelegate redisClientDelegate(JedisPool jedisPool) {
        return new JedisClientDelegate((Pool)jedisPool);
    }

    @Bean
    NamedCacheFactory cacheFactory(RedisClientDelegate redisClientDelegate, ObjectMapper objectMapper, RedisCacheOptions redisCacheOptions, RedisCache.CacheMetrics cacheMetrics) {
        return new RedisNamedCacheFactory(redisClientDelegate, objectMapper, redisCacheOptions, cacheMetrics);
    }
}

