/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.ExecutionInstrumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingInstrumentation
implements ExecutionInstrumentation {
    private final Logger logger = LoggerFactory.getLogger(LoggingInstrumentation.class);

    LoggingInstrumentation() {
    }

    public void executionStarted(Agent agent) {
        this.logger.debug("{}:{} starting", (Object)agent.getProviderName(), (Object)agent.getAgentType());
    }

    public void executionCompleted(Agent agent, long durationMs) {
        this.logger.debug("{}:{} completed in {}s", new Object[]{agent.getProviderName(), agent.getAgentType(), durationMs / 1000L});
    }

    public void executionFailed(Agent agent, Throwable cause, long durationMs) {
        this.logger.warn("{}:{} completed with one or more failures in {}s", new Object[]{agent.getProviderName(), agent.getAgentType(), durationMs / 1000L, cause});
    }
}

