/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.ExecutionInstrumentation;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

class MetricInstrumentation
implements ExecutionInstrumentation {
    private final Registry registry;
    private final Id timingId;

    @Autowired
    MetricInstrumentation(Registry registry) {
        this.registry = registry;
        this.timingId = registry.createId("executionTime").withTag("className", MetricInstrumentation.class.getSimpleName());
    }

    private static String stripPackageName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static String agentName(Agent agent) {
        String simpleProviderName = MetricInstrumentation.stripPackageName(agent.getProviderName());
        return String.format("%s/%s", simpleProviderName, agent.getProviderName());
    }

    public void executionStarted(Agent agent) {
    }

    public void executionCompleted(Agent agent, long elapsedMs) {
        this.registry.timer(this.timingId.withTag("agent", MetricInstrumentation.agentName(agent)).withTag("success", "true")).record(elapsedMs, TimeUnit.MILLISECONDS);
    }

    public void executionFailed(Agent agent, Throwable cause, long elapsedMs) {
        this.registry.timer(this.timingId.withTag("agent", MetricInstrumentation.agentName(agent)).withTag("success", "false")).record(elapsedMs, TimeUnit.MILLISECONDS);
    }
}

