/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupportable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class OnDemandMetricsSupport
implements OnDemandMetricsSupportable {
    private final Timer onDemandTotal;
    private final Timer dataRead;
    private final Timer dataTransform;
    private final Timer onDemandStore;
    private final Timer cacheWrite;
    private final Timer cacheEvict;
    private final Counter onDemandErrors;
    private final Counter onDemandCount;

    public OnDemandMetricsSupport(Registry registry, OnDemandAgent agent, String onDemandType) {
        String[] tags = new String[]{"providerName", agent.getProviderName(), "agentType", agent.getOnDemandAgentType(), "onDemandType", onDemandType};
        this.onDemandTotal = registry.timer("onDemand_total", tags);
        this.dataRead = registry.timer("onDemand_read", tags);
        this.dataTransform = registry.timer("onDemand_transform", tags);
        this.onDemandStore = registry.timer("onDemand_store", tags);
        this.cacheWrite = registry.timer("onDemand_cache", tags);
        this.cacheEvict = registry.timer("onDemand_evict", tags);
        this.onDemandErrors = registry.counter("onDemand_error", tags);
        this.onDemandCount = registry.counter("onDemand_count", tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T record(Timer timer, Supplier<T> closure) {
        long start = System.nanoTime();
        try {
            T t = closure.get();
            return t;
        }
        finally {
            long elapsed = System.nanoTime() - start;
            timer.record(elapsed, TimeUnit.NANOSECONDS);
        }
    }

    public <T> T readData(Supplier<T> closure) {
        return this.record(this.dataRead, closure);
    }

    public <T> T transformData(Supplier<T> closure) {
        return this.record(this.dataTransform, closure);
    }

    public <T> T onDemandStore(Supplier<T> closure) {
        return this.record(this.onDemandStore, closure);
    }

    public <T> T cacheWrite(Supplier<T> closure) {
        return this.record(this.cacheWrite, closure);
    }

    public <T> T cacheEvict(Supplier<T> closure) {
        return this.record(this.cacheEvict, closure);
    }

    public void countError() {
        this.onDemandErrors.increment();
    }

    public void countOnDemand() {
        this.onDemandCount.increment();
    }

    public void recordTotalRunTimeNanos(long nanos) {
        this.onDemandTotal.record(nanos, TimeUnit.NANOSECONDS);
    }
}

