/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.cluster.AgentIntervalProvider;
import com.netflix.spinnaker.cats.cluster.NodeStatusProvider;
import com.netflix.spinnaker.cats.redis.cache.RedisCache;
import com.netflix.spinnaker.cats.redis.cache.RedisCacheOptions;
import com.netflix.spinnaker.clouddriver.cache.CustomSchedulableAgentIntervalProvider;
import com.netflix.spinnaker.clouddriver.cache.DiscoveryStatusNodeStatusProvider;
import com.netflix.spinnaker.clouddriver.cache.SpectatorRedisCacheMetrics;
import com.netflix.spinnaker.clouddriver.core.RedisConfigurationProperties;
import com.netflix.spinnaker.kork.discovery.DiscoveryStatusListener;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="${redis.enabled:true}")
@EnableConfigurationProperties(value={RedisConfigurationProperties.class})
class RedisCacheConfig {
    RedisCacheConfig() {
    }

    @Bean
    @ConfigurationProperties(value="caching.redis")
    RedisCacheOptions.Builder redisCacheOptionsBuilder() {
        return RedisCacheOptions.builder();
    }

    @Bean
    RedisCacheOptions redisCacheOptions(RedisCacheOptions.Builder redisCacheOptionsBuilder) {
        return redisCacheOptionsBuilder.build();
    }

    @Bean
    RedisCache.CacheMetrics cacheMetrics(Registry registry) {
        return new SpectatorRedisCacheMetrics(registry);
    }

    @Bean
    AgentIntervalProvider agentIntervalProvider(RedisConfigurationProperties redisConfigurationProperties) {
        return new CustomSchedulableAgentIntervalProvider(TimeUnit.SECONDS.toMillis(redisConfigurationProperties.getPoll().getIntervalSeconds()), TimeUnit.SECONDS.toMillis(redisConfigurationProperties.getPoll().getIntervalSeconds()), TimeUnit.SECONDS.toMillis(redisConfigurationProperties.getPoll().getIntervalSeconds()));
    }

    @Bean
    NodeStatusProvider nodeStatusProvider(DiscoveryStatusListener discoveryStatusListener) {
        return new DiscoveryStatusNodeStatusProvider(discoveryStatusListener);
    }
}

