/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.netflix.spinnaker.clouddriver.jackson.AccountDefinitionModule;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionMapper;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionRepository;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionSecretManager;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionService;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionTypeProvider;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionTypes;
import com.netflix.spinnaker.clouddriver.security.AccountSecurityPolicy;
import com.netflix.spinnaker.clouddriver.security.AllowAllAccountSecurityPolicy;
import com.netflix.spinnaker.clouddriver.security.AuthorizedRolesExtractor;
import com.netflix.spinnaker.clouddriver.security.DefaultAccountSecurityPolicy;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import com.netflix.spinnaker.kork.secrets.SecretSession;
import com.netflix.spinnaker.kork.secrets.user.UserSecretManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

@Configuration
@EnableConfigurationProperties(value={Properties.class})
public class AccountDefinitionConfiguration {
    @Generated
    private static final Logger log = LogManager.getLogger(AccountDefinitionConfiguration.class);
    private final Properties properties;

    @Bean
    @ConditionalOnMissingBean
    public AccountSecurityPolicy accountSecurity(@Nullable FiatPermissionEvaluator permissionEvaluator, @Value(value="${services.fiat.enabled:false}") boolean fiatEnabled) {
        return fiatEnabled && permissionEvaluator != null ? new DefaultAccountSecurityPolicy(permissionEvaluator) : new AllowAllAccountSecurityPolicy();
    }

    @Bean
    public AccountDefinitionSecretManager accountDefinitionSecretManager(UserSecretManager userSecretManager, AccountSecurityPolicy policy) {
        return new AccountDefinitionSecretManager(userSecretManager, policy);
    }

    @Bean
    public AccountDefinitionMapper accountDefinitionMapper(ObjectMapper mapper, AccountDefinitionSecretManager accountDefinitionSecretManager, SecretManager secretManager) {
        return new AccountDefinitionMapper(mapper, accountDefinitionSecretManager, new SecretSession(secretManager));
    }

    @Bean
    @ConditionalOnBean(value={AccountDefinitionRepository.class})
    public AccountDefinitionService accountDefinitionService(AccountDefinitionRepository repository, AccountDefinitionSecretManager secretManager, AccountCredentialsProvider provider, AccountSecurityPolicy security, List<AuthorizedRolesExtractor> extractors) {
        return new AccountDefinitionService(repository, secretManager, provider, security, extractors);
    }

    @Bean
    public AccountDefinitionModule accountDefinitionModule(List<AccountDefinitionTypeProvider> typeProviders) {
        return new AccountDefinitionModule((NamedType[])typeProviders.stream().flatMap(provider -> provider.getCredentialsTypes().entrySet().stream().map(e -> new NamedType((Class)e.getValue(), (String)e.getKey()))).toArray(NamedType[]::new));
    }

    @Bean
    public AccountDefinitionTypeProvider defaultAccountDefinitionTypeProvider(ResourceLoader loader) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setResourceLoader(loader);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(CredentialsDefinition.class));
        ArrayList<String> scanPackages = new ArrayList<String>(this.properties.additionalScanPackages);
        scanPackages.add(0, "com.netflix.spinnaker.clouddriver");
        return () -> scanPackages.stream().flatMap(packageName -> provider.findCandidateComponents(packageName).stream()).map(BeanDefinition::getBeanClassName).filter(Objects::nonNull).map(className -> this.tryLoadAccountDefinitionClassName((String)className, loader.getClassLoader())).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map.Entry<String, Class<? extends CredentialsDefinition>> tryLoadAccountDefinitionClassName(String className, ClassLoader classLoader) {
        try {
            Class<CredentialsDefinition> subtype = ClassUtils.forName((String)className, (ClassLoader)classLoader).asSubclass(CredentialsDefinition.class);
            String typeName = AccountDefinitionTypes.getCredentialsTypeName(subtype);
            if (typeName != null) {
                log.info("Discovered credentials definition type '{}' from class '{}'", (Object)typeName, subtype);
                return Map.entry(typeName, subtype);
            }
            log.debug("Skipping CredentialsDefinition class '{}' as it does not define a @CredentialsType annotation", subtype);
        }
        catch (ClassNotFoundException e) {
            log.warn("Unable to load CredentialsDefinition class '{}'. Credentials with this type will not be loaded.", (Object)className, (Object)e);
        }
        return null;
    }

    @Generated
    public AccountDefinitionConfiguration(Properties properties) {
        this.properties = properties;
    }

    @ConfigurationProperties(value="account.storage")
    @ConditionalOnProperty(value={"account.storage.enabled"})
    public static class Properties {
        private boolean enabled;
        private List<String> additionalScanPackages = List.of();

        @Generated
        public Properties() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public List<String> getAdditionalScanPackages() {
            return this.additionalScanPackages;
        }

        @Generated
        public Properties setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public Properties setAdditionalScanPackages(List<String> additionalScanPackages) {
            this.additionalScanPackages = additionalScanPackages;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            List<String> this$additionalScanPackages = this.getAdditionalScanPackages();
            List<String> other$additionalScanPackages = other.getAdditionalScanPackages();
            return !(this$additionalScanPackages == null ? other$additionalScanPackages != null : !((Object)this$additionalScanPackages).equals(other$additionalScanPackages));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Properties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            List<String> $additionalScanPackages = this.getAdditionalScanPackages();
            result = result * 59 + ($additionalScanPackages == null ? 43 : ((Object)$additionalScanPackages).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountDefinitionConfiguration.Properties(enabled=" + this.isEnabled() + ", additionalScanPackages=" + this.getAdditionalScanPackages() + ")";
        }
    }
}

