/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.config;

import com.google.common.base.Strings;
import com.netflix.spinnaker.clouddriver.data.task.DualTaskRepository;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(value={"dual-task-repository.enabled"})
@EnableConfigurationProperties(value={Properties.class})
public class DualTaskRepositoryConfiguration {
    private ApplicationContext applicationContext;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Primary
    @Bean
    TaskRepository dualExecutionRepository(Properties properties, List<TaskRepository> allRepositories, DynamicConfigService dynamicConfigService, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        allRepositories.forEach(repo -> this.log.info("Available TaskRepository: " + repo));
        TaskRepository primary = this.findTaskRepository(allRepositories, properties.primaryClass, properties.primaryName);
        TaskRepository previous = this.findTaskRepository(allRepositories, properties.previousClass, properties.previousName);
        return new DualTaskRepository(primary, previous, properties.executorThreadPoolSize, properties.executorTimeoutSeconds, dynamicConfigService);
    }

    private TaskRepository findTaskRepositoryByClass(List<TaskRepository> allRepositories, String className) {
        Class<?> repositoryClass;
        try {
            repositoryClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException("Could not find TaskRepository class", (Throwable)e);
        }
        return allRepositories.stream().filter(repositoryClass::isInstance).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No TaskRepository bean of class %s found", repositoryClass)));
    }

    private TaskRepository findTaskRepository(List<TaskRepository> allRepositories, String beanClass, String beanName) {
        if (!Strings.isNullOrEmpty((String)beanName)) {
            return (TaskRepository)this.applicationContext.getBean(beanName);
        }
        return this.findTaskRepositoryByClass(allRepositories, beanClass);
    }

    @ConfigurationProperties(value="dual-task-repository")
    public static class Properties {
        String primaryClass;
        String primaryName;
        String previousClass;
        String previousName;
        int executorThreadPoolSize = 10;
        long executorTimeoutSeconds = 10L;

        public String getPrimaryClass() {
            return this.primaryClass;
        }

        public void setPrimaryClass(String primaryClass) {
            this.primaryClass = primaryClass;
        }

        public String getPrimaryName() {
            return this.primaryName;
        }

        public void setPrimaryName(String primaryName) {
            this.primaryName = primaryName;
        }

        public String getPreviousClass() {
            return this.previousClass;
        }

        public void setPreviousClass(String previousClass) {
            this.previousClass = previousClass;
        }

        public String getPreviousName() {
            return this.previousName;
        }

        public void setPreviousName(String previousName) {
            this.previousName = previousName;
        }

        public int getExecutorThreadPoolSize() {
            return this.executorThreadPoolSize;
        }

        public void setExecutorThreadPoolSize(int executorThreadPoolSize) {
            this.executorThreadPoolSize = executorThreadPoolSize;
        }

        public long getExecutorTimeoutSeconds() {
            return this.executorTimeoutSeconds;
        }

        public void setExecutorTimeoutSeconds(long executorTimeoutSeconds) {
            this.executorTimeoutSeconds = executorTimeoutSeconds;
        }
    }
}

