/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.config;

import com.jakewharton.retrofit.Ok3Client;
import com.netflix.spinnaker.clouddriver.core.Front50ConfigurationProperties;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.config.DefaultServiceEndpoint;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerRetrofitErrorHandler;
import com.netflix.spinnaker.retrofit.Slf4jRetrofitLogger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit.Endpoint;
import retrofit.Endpoints;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@Configuration
@EnableConfigurationProperties(value={Front50ConfigurationProperties.class})
class RetrofitConfig {
    RetrofitConfig() {
    }

    @Bean
    @ConditionalOnProperty(name={"services.front50.enabled"}, matchIfMissing=true)
    Front50Service front50Service(Front50ConfigurationProperties front50ConfigurationProperties, RestAdapter.LogLevel retrofitLogLevel, OkHttpClientProvider clientProvider, RequestInterceptor spinnakerRequestInterceptor) {
        Endpoint endpoint = Endpoints.newFixedEndpoint((String)front50ConfigurationProperties.getBaseUrl());
        return (Front50Service)new RestAdapter.Builder().setRequestInterceptor(spinnakerRequestInterceptor).setEndpoint(endpoint).setClient((Client)new Ok3Client(clientProvider.getClient((ServiceEndpoint)new DefaultServiceEndpoint("front50", endpoint.getUrl())))).setConverter((Converter)new JacksonConverter()).setLogLevel(retrofitLogLevel).setLog((RestAdapter.Log)new Slf4jRetrofitLogger(Front50Service.class)).setErrorHandler((ErrorHandler)SpinnakerRetrofitErrorHandler.getInstance()).build().create(Front50Service.class);
    }
}

