/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.core;

import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class AccountHealthIndicator<T extends AccountCredentials>
implements HealthIndicator {
    @Nonnull
    private Health health = new Health.Builder().up().build();
    @Nonnull
    private final AtomicLong unhealthyAccounts = new AtomicLong(0L);

    protected AccountHealthIndicator(String id, Registry registry) {
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName(AccountHealthIndicator.metricName(id))).monitorValue((Number)this.unhealthyAccounts);
    }

    private static String metricName(String id) {
        return "health." + id + ".errors";
    }

    public final Health health() {
        return this.health;
    }

    @Scheduled(fixedDelay=300000L)
    public void checkHealth() {
        long errors = 0L;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AccountCredentials account : this.getAccounts()) {
            Optional<String> error = this.accountHealth(account);
            if (!error.isPresent()) continue;
            ++errors;
            builder.put((Object)account.getName(), (Object)error.get());
        }
        this.unhealthyAccounts.set(errors);
        this.health = new Health.Builder().up().withDetails((Map)builder.build()).build();
    }

    protected abstract Iterable<? extends T> getAccounts();

    protected abstract Optional<String> accountHealth(T var1);
}

