/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.core;

import com.netflix.spectator.api.Registry;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public abstract class AlwaysUpHealthIndicator
implements HealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(AlwaysUpHealthIndicator.class);
    protected final AtomicReference<Exception> lastException = new AtomicReference<Object>(null);
    protected final AtomicReference<Boolean> hasInitialized = new AtomicReference<Object>(null);
    private final AtomicLong errors;

    public AlwaysUpHealthIndicator(Registry registry, String name) {
        this.errors = (AtomicLong)registry.gauge("health." + name + ".errors", (Number)new AtomicLong(0L));
    }

    public Health health() {
        if (this.hasInitialized.get() == Boolean.TRUE) {
            return new Health.Builder().up().build();
        }
        Exception ex = this.lastException.get();
        if (ex != null) {
            throw new HealthIndicatorWrappedException(ex);
        }
        return new Health.Builder().unknown().build();
    }

    protected void updateHealth(Runnable healthCheck) {
        try {
            healthCheck.run();
            this.hasInitialized.set(Boolean.TRUE);
            this.lastException.set(null);
            this.errors.set(0L);
        }
        catch (Exception ex) {
            log.error("Unhealthy", (Throwable)ex);
            this.lastException.set(ex);
            this.errors.set(1L);
        }
    }

    private static class HealthIndicatorWrappedException
    extends RuntimeException {
        public HealthIndicatorWrappedException(Throwable cause) {
            super(cause);
        }
    }
}

