/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.core.agent;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.cats.module.CatsModule;
import com.netflix.spinnaker.cats.provider.Provider;
import com.netflix.spinnaker.cats.redis.cache.RedisCacheOptions;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.CoreProvider;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class CleanupPendingOnDemandCachesAgent
implements RunnableAgent,
CustomScheduledAgent {
    private static final Logger log = LoggerFactory.getLogger(CleanupPendingOnDemandCachesAgent.class);
    private static final long DEFAULT_POLL_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final RedisCacheOptions redisCacheOptions;
    private final RedisClientDelegate redisClientDelegate;
    private final ApplicationContext applicationContext;
    private final long pollIntervalMillis;
    private final long timeoutMillis;

    public CleanupPendingOnDemandCachesAgent(RedisCacheOptions redisCacheOptions, RedisClientDelegate redisClientDelegate, ApplicationContext applicationContext) {
        this(redisCacheOptions, redisClientDelegate, applicationContext, DEFAULT_POLL_INTERVAL_MILLIS, DEFAULT_TIMEOUT_MILLIS);
    }

    private CleanupPendingOnDemandCachesAgent(RedisCacheOptions redisCacheOptions, RedisClientDelegate redisClientDelegate, ApplicationContext applicationContext, long pollIntervalMillis, long timeoutMillis) {
        this.redisCacheOptions = redisCacheOptions;
        this.redisClientDelegate = redisClientDelegate;
        this.applicationContext = applicationContext;
        this.pollIntervalMillis = pollIntervalMillis;
        this.timeoutMillis = timeoutMillis;
    }

    public String getAgentType() {
        return CleanupPendingOnDemandCachesAgent.class.getSimpleName();
    }

    public String getProviderName() {
        return CoreProvider.PROVIDER_NAME;
    }

    public void run() {
        this.run(this.getCatsModule().getProviderRegistry().getProviders());
    }

    void run(Collection<Provider> providers) {
        providers.forEach(provider -> {
            String onDemandSetName = provider.getProviderName() + ":onDemand:members";
            List onDemandKeys = this.scanMembers(onDemandSetName).stream().filter(s -> !s.equals("_ALL_")).collect(Collectors.toList());
            HashMap existingOnDemandKeys = new HashMap();
            if (this.redisClientDelegate.supportsMultiKeyPipelines()) {
                this.redisClientDelegate.withMultiKeyPipeline(pipeline -> {
                    for (List partition : Iterables.partition((Iterable)onDemandKeys, (int)this.redisCacheOptions.getMaxDelSize())) {
                        for (String id : partition) {
                            existingOnDemandKeys.put(id, pipeline.exists(provider.getProviderName() + ":onDemand:attributes:" + id));
                        }
                    }
                    pipeline.sync();
                });
            } else {
                this.redisClientDelegate.withCommandsClient(client -> onDemandKeys.stream().filter(k -> client.exists(provider.getProviderName() + "onDemand:attributes:" + k)).forEach(k -> existingOnDemandKeys.put(k, new StaticResponse(Boolean.TRUE))));
            }
            ArrayList<String> onDemandKeysToRemove = new ArrayList<String>();
            for (String onDemandKey : onDemandKeys) {
                if (existingOnDemandKeys.containsKey(onDemandKey) && ((Boolean)((Response)existingOnDemandKeys.get(onDemandKey)).get()).booleanValue()) continue;
                onDemandKeysToRemove.add(onDemandKey);
            }
            if (!onDemandKeysToRemove.isEmpty()) {
                log.info("Removing {} from {}", (Object)onDemandKeysToRemove.size(), (Object)onDemandSetName);
                log.debug("Removing {} from {}", onDemandKeysToRemove, (Object)onDemandSetName);
                this.redisClientDelegate.withMultiKeyPipeline(pipeline -> {
                    for (List idPartition : Lists.partition((List)onDemandKeysToRemove, (int)this.redisCacheOptions.getMaxDelSize())) {
                        String[] ids = idPartition.toArray(new String[idPartition.size()]);
                        pipeline.srem(onDemandSetName, ids);
                    }
                    pipeline.sync();
                });
            }
        });
    }

    @Override
    public long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    private Set<String> scanMembers(String setKey) {
        return (Set)this.redisClientDelegate.withCommandsClient(client -> {
            ScanResult scanResult;
            HashSet matches = new HashSet();
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(this.redisCacheOptions.getScanSize()));
            String cursor = "0";
            do {
                scanResult = client.sscan(setKey, cursor, scanParams);
                matches.addAll(scanResult.getResult());
            } while (!"0".equals(cursor = scanResult.getCursor()));
            return matches;
        });
    }

    private CatsModule getCatsModule() {
        return (CatsModule)this.applicationContext.getBean(CatsModule.class);
    }

    private static class StaticResponse
    extends Response<Boolean> {
        private final Boolean value;

        StaticResponse(Boolean value) {
            super(null);
            this.value = value;
        }

        public Boolean get() {
            return this.value;
        }
    }
}

