/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.core.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.config.ProjectClustersCachingAgentProperties;
import com.netflix.spinnaker.clouddriver.core.ProjectClustersService;
import com.netflix.spinnaker.clouddriver.core.provider.CoreProvider;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ProjectClustersCachingAgent
implements CachingAgent,
CustomScheduledAgent {
    private static final long DEFAULT_POLL_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    private final Collection<AgentDataType> types;
    private final ProjectClustersService projectClustersService;
    private final ProjectClustersCachingAgentProperties properties;

    public ProjectClustersCachingAgent(ProjectClustersService projectClustersService, ProjectClustersCachingAgentProperties properties) {
        this.types = Collections.singletonList(AgentDataType.Authority.AUTHORITATIVE.forType(Namespace.PROJECT_CLUSTERS.ns));
        this.projectClustersService = projectClustersService;
        this.properties = properties;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        return new DefaultCacheResult(Collections.singletonMap(Namespace.PROJECT_CLUSTERS.ns, Collections.singletonList(new MutableCacheData("v1", new HashMap<String, Object>(this.projectClustersService.getProjectClusters(this.properties.getNormalizedAllowList())), Collections.emptyMap()))));
    }

    @Override
    public long getPollIntervalMillis() {
        return DEFAULT_POLL_INTERVAL_MILLIS;
    }

    @Override
    public long getTimeoutMillis() {
        return DEFAULT_TIMEOUT_MILLIS;
    }

    public String getAgentType() {
        return ProjectClustersCachingAgent.class.getSimpleName();
    }

    public String getProviderName() {
        return CoreProvider.PROVIDER_NAME;
    }

    static class MutableCacheData
    implements CacheData {
        private final String id;
        private final int ttlSeconds = -1;
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Map<String, Collection<String>> relationships = new HashMap<String, Collection<String>>();

        public MutableCacheData(String id) {
            this.id = id;
        }

        @JsonCreator
        public MutableCacheData(String id, Map<String, Object> attributes, Map<String, Collection<String>> relationships) {
            this.id = id;
            this.attributes.putAll(attributes);
            this.relationships.putAll(relationships);
        }

        public String getId() {
            return this.id;
        }

        public int getTtlSeconds() {
            return -1;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public Map<String, Collection<String>> getRelationships() {
            return this.relationships;
        }
    }
}

