/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.core.limits;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.core.limits.ServiceLimits;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class ImplementationLimits {
    private final ServiceLimits defaults;
    private final Map<String, ServiceLimits> accountOverrides;

    public ImplementationLimits(ServiceLimits defaults, Map<String, ServiceLimits> accountOverrides) {
        this.defaults = defaults == null ? new ServiceLimits(null) : defaults;
        this.accountOverrides = accountOverrides == null ? Collections.emptyMap() : ImmutableMap.copyOf(accountOverrides);
    }

    public Double getLimit(String limit, String account) {
        return Optional.ofNullable(account).map(this.accountOverrides::get).map(sl -> sl.getLimit(limit)).orElse(this.defaults.getLimit(limit));
    }
}

