/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.core.limits;

import com.netflix.spinnaker.clouddriver.core.limits.ImplementationLimits;
import com.netflix.spinnaker.clouddriver.core.limits.ServiceLimitConfiguration;
import com.netflix.spinnaker.clouddriver.core.limits.ServiceLimits;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ServiceLimitConfigurationBuilder {
    private MutableLimits defaults = new MutableLimits();
    private Map<String, MutableLimits> cloudProviderOverrides = new HashMap<String, MutableLimits>();
    private Map<String, MutableLimits> accountOverrides = new HashMap<String, MutableLimits>();
    private Map<String, MutableImplementationLimits> implementationLimits = new HashMap<String, MutableImplementationLimits>();

    public MutableLimits getDefaults() {
        return this.defaults;
    }

    public void setDefaults(MutableLimits defaults) {
        this.defaults = defaults;
    }

    public ServiceLimitConfigurationBuilder withDefault(String limit, Double value) {
        if (this.defaults == null) {
            this.defaults = new MutableLimits();
        }
        this.defaults.setLimit(limit, value);
        return this;
    }

    public Map<String, MutableLimits> getCloudProviderOverrides() {
        return this.cloudProviderOverrides;
    }

    public void setCloudProviderOverrides(Map<String, MutableLimits> cloudProviderOverrides) {
        this.cloudProviderOverrides = cloudProviderOverrides;
    }

    public ServiceLimitConfigurationBuilder withCloudProviderOverride(String cloudProvider, String limit, Double value) {
        if (this.cloudProviderOverrides == null) {
            this.cloudProviderOverrides = new HashMap<String, MutableLimits>();
        }
        this.cloudProviderOverrides.computeIfAbsent(cloudProvider, k -> new MutableLimits()).setLimit(limit, value);
        return this;
    }

    public Map<String, MutableLimits> getAccountOverrides() {
        return this.accountOverrides;
    }

    public void setAccountOverrides(Map<String, MutableLimits> accountOverrides) {
        this.accountOverrides = accountOverrides;
    }

    public ServiceLimitConfigurationBuilder withAccountOverride(String account, String limit, Double value) {
        if (this.accountOverrides == null) {
            this.accountOverrides = new HashMap<String, MutableLimits>();
        }
        this.accountOverrides.computeIfAbsent(account, k -> new MutableLimits()).setLimit(limit, value);
        return this;
    }

    public Map<String, MutableImplementationLimits> getImplementationLimits() {
        return this.implementationLimits;
    }

    public void setImplementationLimits(Map<String, MutableImplementationLimits> implementationLimits) {
        this.implementationLimits = implementationLimits;
    }

    public ServiceLimitConfigurationBuilder withImplementationDefault(String implementation, String limit, Double value) {
        if (this.implementationLimits == null) {
            this.implementationLimits = new HashMap<String, MutableImplementationLimits>();
        }
        this.implementationLimits.computeIfAbsent((String)implementation, (Function<String, MutableImplementationLimits>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$withImplementationDefault$2(java.lang.String ), (Ljava/lang/String;)Lcom/netflix/spinnaker/clouddriver/core/limits/ServiceLimitConfigurationBuilder$MutableImplementationLimits;)()).defaults.setLimit(limit, value);
        return this;
    }

    public ServiceLimitConfigurationBuilder withImplementationAccountOverride(String implementation, String account, String limit, Double value) {
        if (this.implementationLimits == null) {
            this.implementationLimits = new HashMap<String, MutableImplementationLimits>();
        }
        this.implementationLimits.computeIfAbsent((String)implementation, (Function<String, MutableImplementationLimits>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$withImplementationAccountOverride$3(java.lang.String ), (Ljava/lang/String;)Lcom/netflix/spinnaker/clouddriver/core/limits/ServiceLimitConfigurationBuilder$MutableImplementationLimits;)()).accountOverrides.computeIfAbsent(account, k -> new MutableLimits()).setLimit(limit, value);
        return this;
    }

    public ServiceLimitConfiguration build() {
        return new ServiceLimitConfiguration(new ServiceLimits(this.defaults), ServiceLimitConfigurationBuilder.toServiceLimits(this.cloudProviderOverrides), ServiceLimitConfigurationBuilder.toServiceLimits(this.accountOverrides), ServiceLimitConfigurationBuilder.toImplementationLimits(this.implementationLimits));
    }

    private static <S, D> Map<String, D> toImmutable(Map<String, S> src, Function<Map.Entry<String, S>, D> converter) {
        return Optional.ofNullable(src).map(Map::entrySet).map(Collection::stream).map(s -> s.collect(Collectors.toMap(Map.Entry::getKey, converter))).orElse(Collections.emptyMap());
    }

    private static Map<String, ServiceLimits> toServiceLimits(Map<String, MutableLimits> limits) {
        return ServiceLimitConfigurationBuilder.toImmutable(limits, mapEntry -> new ServiceLimits((Map)mapEntry.getValue()));
    }

    private static Map<String, ImplementationLimits> toImplementationLimits(Map<String, MutableImplementationLimits> implementationLimits) {
        return ServiceLimitConfigurationBuilder.toImmutable(implementationLimits, mapEntry -> ((MutableImplementationLimits)mapEntry.getValue()).toImplementationLimits());
    }

    private static /* synthetic */ MutableImplementationLimits lambda$withImplementationAccountOverride$3(String k) {
        return new MutableImplementationLimits();
    }

    private static /* synthetic */ MutableImplementationLimits lambda$withImplementationDefault$2(String k) {
        return new MutableImplementationLimits();
    }

    public static class MutableImplementationLimits {
        MutableLimits defaults = new MutableLimits();
        Map<String, MutableLimits> accountOverrides = new HashMap<String, MutableLimits>();

        public ImplementationLimits toImplementationLimits() {
            return new ImplementationLimits(new ServiceLimits(this.defaults), ServiceLimitConfigurationBuilder.toServiceLimits(this.accountOverrides));
        }

        public MutableLimits getDefaults() {
            return this.defaults;
        }

        public void setDefaults(MutableLimits defaults) {
            this.defaults = defaults;
        }

        public Map<String, MutableLimits> getAccountOverrides() {
            return this.accountOverrides;
        }

        public void setAccountOverrides(Map<String, MutableLimits> accountOverrides) {
            this.accountOverrides = accountOverrides;
        }
    }

    public static class MutableLimits
    extends HashMap<String, Double> {
        public void setLimit(String limit, Double value) {
            this.put(limit, value);
        }

        public Double getLimit(String limit) {
            return (Double)this.get(limit);
        }
    }
}

