/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.core.services;

import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.model.Front50Application;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;
import retrofit.http.QueryMap;

public interface Front50Service {
    @GET(value="/credentials")
    public List<Map> getCredentials();

    @GET(value="/v2/applications")
    public List<Map<String, Object>> searchByName(@Query(value="name") String var1, @Query(value="pageSize") Integer var2, @QueryMap Map<String, String> var3);

    @GET(value="/v2/applications/{applicationName}")
    public Map getApplication(@Path(value="applicationName") String var1);

    @GET(value="/v2/applications?restricted=false")
    public Set<Front50Application> getAllApplicationsUnrestricted();

    @GET(value="/v2/projects/{project}")
    public Map getProject(@Path(value="project") String var1);

    @GET(value="/v2/projects")
    public List<Map<String, Object>> searchForProjects(@QueryMap Map<String, String> var1, @Query(value="pageSize") Integer var2);

    @POST(value="/snapshots")
    public Response saveSnapshot(@Body Map var1);

    @GET(value="/snapshots/{id}/{timestamp}")
    public Map getSnapshotVersion(@Path(value="id") String var1, @Path(value="timestamp") String var2);

    @POST(value="/v2/tags")
    public EntityTags saveEntityTags(@Body EntityTags var1);

    @POST(value="/v2/tags/batchUpdate")
    public Collection<EntityTags> batchUpdate(@Body Collection<EntityTags> var1);

    @GET(value="/v2/tags/{id}")
    public EntityTags getEntityTags(@Path(value="id") String var1);

    @GET(value="/v2/tags")
    public List<EntityTags> getAllEntityTagsById(@Query(value="ids") List<String> var1);

    @GET(value="/v2/tags?prefix=")
    public Collection<EntityTags> getAllEntityTags(@Query(value="refresh") boolean var1);

    @DELETE(value="/v2/tags/{id}")
    public Response deleteEntityTags(@Path(value="id") String var1);

    @GET(value="/v2/pipelineTemplates/{pipelineTemplateId}")
    public Map getV2PipelineTemplate(@Path(value="pipelineTemplateId") String var1, @Query(value="version") String var2, @Query(value="digest") String var3);

    @GET(value="/v2/pipelineTemplates")
    public List<Map> listV2PipelineTemplates(@Query(value="scopes") List<String> var1);
}

