/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.data.task;

import com.netflix.spinnaker.clouddriver.core.ClouddriverHostname;
import com.netflix.spinnaker.clouddriver.data.task.DefaultTaskStatus;
import com.netflix.spinnaker.clouddriver.data.task.SagaId;
import com.netflix.spinnaker.clouddriver.data.task.Status;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskDisplayStatus;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class DefaultTask
implements Task {
    private static final Logger log = Logger.getLogger(DefaultTask.class.getName());
    private final String id;
    private final String ownerId = ClouddriverHostname.ID;
    private final String requestId;
    private final Deque<Status> statusHistory = new ConcurrentLinkedDeque<Status>();
    private final Deque<Object> resultObjects = new ConcurrentLinkedDeque<Object>();
    private final Deque<SagaId> sagaIdentifiers = new ConcurrentLinkedDeque<SagaId>();
    private final long startTimeMs = System.currentTimeMillis();

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    public DefaultTask(String id) {
        this(id, "INIT", "Creating task " + id);
    }

    public DefaultTask(String id, String phase, String status) {
        this.requestId = null;
        DefaultTaskStatus initialStatus = new DefaultTaskStatus(phase, status, TaskState.STARTED);
        this.statusHistory.addLast(initialStatus);
        this.id = id;
    }

    @Override
    public void updateStatus(String phase, String status) {
        this.statusHistory.addLast(this.currentStatus().update(phase, status));
        log.info("[" + phase + "] - " + status);
    }

    @Override
    public void complete() {
        this.statusHistory.addLast(this.currentStatus().update(TaskState.COMPLETED));
    }

    @Override
    public List<? extends Status> getHistory() {
        return this.statusHistory.stream().map(TaskDisplayStatus::new).collect(Collectors.toList());
    }

    @Override
    public void fail() {
        this.statusHistory.addLast(this.currentStatus().update(TaskState.FAILED));
    }

    @Override
    public void fail(boolean retryable) {
        this.statusHistory.addLast(this.currentStatus().update(retryable ? TaskState.FAILED_RETRYABLE : TaskState.FAILED));
    }

    @Override
    public Status getStatus() {
        return this.currentStatus();
    }

    public String toString() {
        return this.getStatus().toString();
    }

    @Override
    public void addResultObjects(List<Object> results) {
        if (results != null && !results.isEmpty()) {
            this.currentStatus().ensureUpdateable();
            this.resultObjects.addAll(results);
        }
    }

    @Override
    public List<Object> getResultObjects() {
        return new ArrayList<Object>(this.resultObjects);
    }

    private DefaultTaskStatus currentStatus() {
        return (DefaultTaskStatus)this.statusHistory.getLast();
    }

    @Override
    public void addSagaId(@Nonnull SagaId sagaId) {
        this.sagaIdentifiers.addLast(sagaId);
    }

    @Override
    public Set<SagaId> getSagaIds() {
        return DefaultGroovyMethods.toSet(this.sagaIdentifiers);
    }

    @Override
    public boolean hasSagaIds() {
        return !this.sagaIdentifiers.isEmpty();
    }

    @Override
    public void retry() {
        this.statusHistory.addLast(this.currentStatus().update(TaskState.STARTED));
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getRequestId() {
        return this.requestId;
    }

    @Override
    public final long getStartTimeMs() {
        return this.startTimeMs;
    }
}

