/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.data.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.clouddriver.data.task.Status;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import com.netflix.spinnaker.kork.annotations.VisibleForTesting;

public class DefaultTaskStatus
implements Status {
    private final String phase;
    private final String status;
    @JsonIgnore
    private final TaskState state;

    public static DefaultTaskStatus create(String phase, String status, TaskState state) {
        return new DefaultTaskStatus(phase, status, state);
    }

    public DefaultTaskStatus(String phase, String status, TaskState state) {
        this.phase = phase;
        this.status = status;
        this.state = state;
    }

    @VisibleForTesting
    public DefaultTaskStatus(TaskState state) {
        this.phase = null;
        this.status = null;
        this.state = state;
    }

    @JsonProperty
    public Boolean isComplete() {
        return this.state.isCompleted();
    }

    @Override
    @JsonProperty
    public Boolean isCompleted() {
        return this.state.isCompleted();
    }

    @Override
    @JsonProperty
    public Boolean isFailed() {
        return this.state.isFailed();
    }

    @Override
    @JsonProperty
    public Boolean isRetryable() {
        return this.state.isRetryable();
    }

    public DefaultTaskStatus update(String phase, String status) {
        this.ensureUpdateable();
        return new DefaultTaskStatus(phase, status, this.state);
    }

    public DefaultTaskStatus update(TaskState state) {
        this.ensureUpdateable();
        return new DefaultTaskStatus(this.phase, this.status, state);
    }

    public void ensureUpdateable() {
        if (this.isCompleted().booleanValue()) {
            throw new IllegalStateException("Task is already completed! No further updates allowed!");
        }
    }

    @Override
    public final String getPhase() {
        return this.phase;
    }

    @Override
    public final String getStatus() {
        return this.status;
    }

    public final TaskState getState() {
        return this.state;
    }
}

