/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.data.task;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualTaskRepository
implements TaskRepository {
    private static final Logger log = LoggerFactory.getLogger(DualTaskRepository.class);
    private final TaskRepository primary;
    private final TaskRepository previous;
    private final ExecutorService executorService;
    private final long asyncTimeoutSeconds;
    private final DynamicConfigService dynamicConfigService;

    public DualTaskRepository(TaskRepository primary, TaskRepository previous, int threadPoolSize, long asyncTimeoutSeconds, DynamicConfigService dynamicConfigService) {
        this(primary, previous, Executors.newFixedThreadPool(threadPoolSize, new ThreadFactoryBuilder().setNameFormat(DualTaskRepository.class.getSimpleName() + "-%d").build()), asyncTimeoutSeconds, dynamicConfigService);
    }

    public DualTaskRepository(TaskRepository primary, TaskRepository previous, ExecutorService executorService, long asyncTimeoutSeconds, DynamicConfigService dynamicConfigService) {
        this.primary = primary;
        this.previous = previous;
        this.executorService = executorService;
        this.asyncTimeoutSeconds = asyncTimeoutSeconds;
        this.dynamicConfigService = dynamicConfigService;
    }

    @Override
    public Task create(String phase, String status) {
        return this.primary.create(phase, status);
    }

    @Override
    public Task create(String phase, String status, String clientRequestId) {
        return this.primary.create(phase, status, clientRequestId);
    }

    @Override
    public Task get(String id) {
        Task task = this.primary.get(id);
        if (task == null && this.dynamicConfigService.isEnabled("dualtaskrepo.previous", true)) {
            task = this.previous.get(id);
        }
        return task;
    }

    @Override
    public Task getByClientRequestId(String clientRequestId) {
        Task task = this.primary.getByClientRequestId(clientRequestId);
        if (task == null && this.dynamicConfigService.isEnabled("dualtaskrepo.previous", true)) {
            task = this.previous.getByClientRequestId(clientRequestId);
        }
        return task;
    }

    @Override
    public List<Task> list() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        try {
            Future<List> primaryList = this.executorService.submit(this.primary::list);
            List tasksFromPrevious = Collections.emptyList();
            tasks.addAll(primaryList.get(this.asyncTimeoutSeconds, TimeUnit.SECONDS));
            if (this.dynamicConfigService.isEnabled("dualtaskrepo.previous", true)) {
                Future<List> previousList = this.executorService.submit(this.previous::list);
                tasksFromPrevious = previousList.get(this.asyncTimeoutSeconds, TimeUnit.SECONDS);
            }
            Set primaryTasks = tasks.stream().map(Task::getId).collect(Collectors.toSet());
            tasksFromPrevious.stream().filter(task -> !primaryTasks.contains(task.getId())).forEach(tasks::add);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Could not retrieve list of tasks by timeout", (Throwable)e);
        }
        return tasks;
    }

    @Override
    public List<Task> listByThisInstance() {
        return this.primary.listByThisInstance();
    }
}

