/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.data.task;

import com.netflix.spinnaker.clouddriver.data.task.SagaId;
import com.netflix.spinnaker.clouddriver.data.task.Status;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public interface Task {
    public String getId();

    public String getRequestId();

    public List<Object> getResultObjects();

    public void addResultObjects(List<Object> var1);

    public List<? extends Status> getHistory();

    public String getOwnerId();

    public void updateStatus(String var1, String var2);

    public void complete();

    @Deprecated
    public void fail();

    public void fail(boolean var1);

    public Status getStatus();

    public long getStartTimeMs();

    public void addSagaId(@Nonnull SagaId var1);

    public boolean hasSagaIds();

    @Nonnull
    public Set<SagaId> getSagaIds();

    default public boolean isRetryable() {
        if (!this.hasSagaIds()) {
            return false;
        }
        return this.getStatus().isFailed() != false && this.getStatus().isRetryable() != false;
    }

    public void retry();
}

