/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.data.task.jedis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Iterables;
import com.netflix.spinnaker.clouddriver.data.task.SagaId;
import com.netflix.spinnaker.clouddriver.data.task.Status;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskState;
import com.netflix.spinnaker.clouddriver.data.task.jedis.RedisTaskRepository;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"status", "history"})
public class JedisTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(JedisTask.class);
    @JsonIgnore
    private RedisTaskRepository repository;
    private final String id;
    private final long startTimeMs;
    private final String ownerId;
    private final String requestId;
    private final Set<SagaId> sagaIds;
    @JsonIgnore
    private final boolean previousRedis;

    public JedisTask(String id, long startTimeMs, RedisTaskRepository repository, String ownerId, String requestId, Set<SagaId> sagaIds, boolean previousRedis) {
        this.id = id;
        this.startTimeMs = startTimeMs;
        this.repository = repository;
        this.ownerId = ownerId;
        this.requestId = requestId;
        this.sagaIds = sagaIds;
        this.previousRedis = previousRedis;
    }

    @Override
    public void updateStatus(String phase, String status) {
        this.checkMutable();
        this.repository.addToHistory(this.repository.currentState(this).update(phase, status), this);
        log.info("[" + phase + "] " + status);
    }

    @Override
    public void complete() {
        this.checkMutable();
        this.repository.addToHistory(this.repository.currentState(this).update(TaskState.COMPLETED), this);
    }

    @Override
    @Deprecated
    public void fail() {
        this.checkMutable();
        this.repository.addToHistory(this.repository.currentState(this).update(TaskState.FAILED), this);
    }

    @Override
    public void fail(boolean retryable) {
        this.checkMutable();
        this.repository.addToHistory(this.repository.currentState(this).update(retryable ? TaskState.FAILED_RETRYABLE : TaskState.FAILED), this);
    }

    @Override
    public void addResultObjects(List<Object> results) {
        this.checkMutable();
        if (DefaultGroovyMethods.asBoolean(results)) {
            this.repository.currentState(this).ensureUpdateable();
            this.repository.addResultObjects(results, this);
        }
    }

    @Override
    public List<Object> getResultObjects() {
        return this.repository.getResultObjects(this);
    }

    @Override
    public List<? extends Status> getHistory() {
        List<Status> status = this.repository.getHistory(this);
        if (status != null && !status.isEmpty() && ((Status)Iterables.getLast(status)).isCompleted().booleanValue()) {
            return status.subList(0, status.size() - 1);
        }
        return status;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public Status getStatus() {
        return this.repository.currentState(this);
    }

    @Override
    public void addSagaId(@Nonnull SagaId sagaId) {
        this.sagaIds.add(sagaId);
    }

    @Override
    public boolean hasSagaIds() {
        return !this.sagaIds.isEmpty();
    }

    @Override
    public void retry() {
        this.checkMutable();
        this.repository.addToHistory(this.repository.currentState(this).update(TaskState.STARTED), this);
    }

    private void checkMutable() {
        if (this.previousRedis) {
            throw new IllegalStateException("Read-only task");
        }
    }

    public RedisTaskRepository getRepository() {
        return this.repository;
    }

    public void setRepository(RedisTaskRepository repository) {
        this.repository = repository;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final long getStartTimeMs() {
        return this.startTimeMs;
    }

    @Override
    public final String getRequestId() {
        return this.requestId;
    }

    @Override
    public final Set<SagaId> getSagaIds() {
        return this.sagaIds;
    }

    public final boolean getPreviousRedis() {
        return this.previousRedis;
    }

    public final boolean isPreviousRedis() {
        return this.previousRedis;
    }
}

