/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.deploy;

import com.netflix.spinnaker.clouddriver.deploy.DeployDescription;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandler;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandlerNotFoundException;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandlerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DefaultDeployHandlerRegistry
implements DeployHandlerRegistry {
    private List<DeployHandler> deployHandlers;

    public DefaultDeployHandlerRegistry(List<DeployHandler> deployHandlers) {
        this.deployHandlers = deployHandlers;
    }

    @Override
    public DeployHandler findHandler(DeployDescription description) {
        return Optional.ofNullable(this.deployHandlers).orElseGet(ArrayList::new).stream().filter(it -> it != null && it.handles(description)).findFirst().orElseThrow(() -> new DeployHandlerNotFoundException(String.format("No handler found supporting %s", description.getClass().getSimpleName())));
    }
}

