/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.deploy;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionSecretManager;
import com.netflix.spinnaker.clouddriver.security.config.SecurityConfig;
import com.netflix.spinnaker.clouddriver.security.resources.AccountNameable;
import com.netflix.spinnaker.clouddriver.security.resources.ApplicationNameable;
import com.netflix.spinnaker.clouddriver.security.resources.ResourcesNameable;
import com.netflix.spinnaker.fiat.model.resources.ResourceType;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.Errors;

public class DescriptionAuthorizerService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Registry registry;
    private final FiatPermissionEvaluator fiatPermissionEvaluator;
    private final SecurityConfig.OperationsSecurityConfigurationProperties opsSecurityConfigProps;
    private final AccountDefinitionSecretManager secretManager;
    private final Id skipAuthorizationId;
    private final Id missingApplicationId;
    private final Id authorizationId;

    public DescriptionAuthorizerService(Registry registry, Optional<FiatPermissionEvaluator> fiatPermissionEvaluator, SecurityConfig.OperationsSecurityConfigurationProperties opsSecurityConfigProps, AccountDefinitionSecretManager secretManager) {
        this.registry = registry;
        this.fiatPermissionEvaluator = fiatPermissionEvaluator.orElse(null);
        this.opsSecurityConfigProps = opsSecurityConfigProps;
        this.secretManager = secretManager;
        this.skipAuthorizationId = registry.createId("authorization.skipped");
        this.missingApplicationId = registry.createId("authorization.missingApplication");
        this.authorizationId = registry.createId("authorization");
    }

    public void authorize(Object description, Errors errors) {
        this.authorize(description, errors, List.of(ResourceType.ACCOUNT, ResourceType.APPLICATION));
    }

    public void authorize(Object description, Errors errors, Collection<ResourceType> resourceTypes) {
        if (this.fiatPermissionEvaluator == null || description == null) {
            return;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String account = null;
        ArrayList applications = new ArrayList();
        boolean requiresApplicationRestriction = true;
        if (description instanceof AccountNameable) {
            AccountNameable accountNameable = (AccountNameable)description;
            requiresApplicationRestriction = accountNameable.requiresApplicationRestriction();
            if (!accountNameable.requiresAuthorization(this.opsSecurityConfigProps)) {
                this.registry.counter(this.skipAuthorizationId.withTag("descriptionClass", description.getClass().getSimpleName())).increment();
                this.log.info("Skipping authorization for operation `{}` in account `{}`.", (Object)description.getClass().getSimpleName(), (Object)accountNameable.getAccount());
            } else {
                account = accountNameable.getAccount();
            }
        }
        if (description instanceof ApplicationNameable) {
            ApplicationNameable applicationNameable = (ApplicationNameable)description;
            applications.addAll(((Collection)Optional.ofNullable(applicationNameable.getApplications()).orElse(Collections.emptyList())).stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (description instanceof ResourcesNameable) {
            ResourcesNameable resourcesNameable = (ResourcesNameable)description;
            applications.addAll(((Collection)Optional.ofNullable(resourcesNameable.getResourceApplications()).orElse(Collections.emptyList())).stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        boolean hasPermission = true;
        if (resourceTypes.contains(ResourceType.ACCOUNT) && account != null && !this.secretManager.canAccessAccountWithSecrets(auth.getName(), account)) {
            hasPermission = false;
            errors.reject("authorization.account", String.format("Access denied to account %s", account));
        }
        if (resourceTypes.contains(ResourceType.APPLICATION) && !applications.isEmpty()) {
            this.fiatPermissionEvaluator.storeWholePermission();
            for (String application : applications) {
                if (this.fiatPermissionEvaluator.hasPermission(auth, (Serializable)((Object)application), "APPLICATION", (Object)"WRITE")) continue;
                hasPermission = false;
                errors.reject("authorization.application", String.format("Access denied to application %s", application));
            }
        }
        if (requiresApplicationRestriction && account != null && applications.isEmpty()) {
            this.registry.counter(this.missingApplicationId.withTag("descriptionClass", description.getClass().getSimpleName()).withTag("hasValidationErrors", errors.hasErrors())).increment();
            this.log.warn("No application(s) specified for operation with account restriction (type: {}, account: {}, hasValidationErrors: {})", new Object[]{description.getClass().getSimpleName(), account, errors.hasErrors()});
        }
        this.registry.counter(this.authorizationId.withTag("descriptionClass", description.getClass().getSimpleName()).withTag("success", hasPermission)).increment();
    }
}

