/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.deploy;

import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class DescriptionValidationErrors
extends AbstractErrors
implements ValidationErrors {
    private Object description;
    private List<ObjectError> globalErrors = new ArrayList<ObjectError>();
    private List<FieldError> fieldErrors = new ArrayList<FieldError>();

    public DescriptionValidationErrors(Object description) {
        this.description = description;
    }

    @Nonnull
    public String getObjectName() {
        return this.description.getClass().getSimpleName();
    }

    public void reject(@Nonnull String errorCode, Object[] errorArgs, String defaultMessage) {
        this.globalErrors.add(new ObjectError(this.getObjectName(), new String[]{errorCode}, errorArgs, defaultMessage));
    }

    public void rejectValue(String field, @Nonnull String errorCode, Object[] errorArgs, String defaultMessage) {
        this.fieldErrors.add(new FieldError(this.getObjectName(), field, null, false, new String[]{errorCode}, errorArgs, defaultMessage));
    }

    public void addAllErrors(Errors errors) {
        this.globalErrors.addAll(errors.getAllErrors());
    }

    public Object getFieldValue(@Nonnull String field) {
        return this.description.getClass().getDeclaredField(field).get(this.description);
    }

    public Object getDescription() {
        return this.description;
    }

    public void setDescription(Object description) {
        this.description = description;
    }

    @Nonnull
    public List<ObjectError> getGlobalErrors() {
        return this.globalErrors;
    }

    public void setGlobalErrors(List<ObjectError> globalErrors) {
        this.globalErrors = globalErrors;
    }

    @Nonnull
    public List<FieldError> getFieldErrors() {
        return this.fieldErrors;
    }

    public void setFieldErrors(List<FieldError> fieldErrors) {
        this.fieldErrors = fieldErrors;
    }
}

