/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.helpers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;

public class EnableDisablePercentageCategorizer {
    public static <T> List<T> getInstancesToModify(List<T> modified, List<T> unmodified, int desiredPercentage) {
        if (desiredPercentage < 0 || desiredPercentage > 100) {
            throw new RuntimeException("Desired target percentage must be between 0 and 100 inclusive");
        }
        int totalSize = modified.size() + unmodified.size();
        int newSize = (int)Math.ceil((double)(totalSize * desiredPercentage) / 100.0);
        int returnSize = modified.size() > newSize ? 0 : newSize - modified.size();
        return Lists.newArrayList((Iterable)Iterables.limit(unmodified, (int)returnSize));
    }
}

