/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.jobs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.exec.CommandLine;

public class JobRequest {
    private final List<String> tokenizedCommand;
    private final CommandLine commandLine;
    private final Map<String, String> environment;
    private final InputStream inputStream;
    private final File workingDir;

    public JobRequest(List<String> tokenizedCommand) {
        this(tokenizedCommand, System.getenv(), new ByteArrayInputStream(new byte[0]));
    }

    public JobRequest(List<String> tokenizedCommand, InputStream inputStream) {
        this(tokenizedCommand, System.getenv(), inputStream);
    }

    public JobRequest(List<String> tokenizedCommand, Map<String, String> environment, InputStream inputStream) {
        this(tokenizedCommand, environment, inputStream, null);
    }

    public JobRequest(List<String> tokenizedCommand, Map<String, String> environment, File workingDir) {
        this(tokenizedCommand, environment, new ByteArrayInputStream(new byte[0]), workingDir);
    }

    public JobRequest(List<String> tokenizedCommand, InputStream inputStream, File workingDir) {
        this(tokenizedCommand, System.getenv(), inputStream, workingDir);
    }

    public JobRequest(List<String> tokenizedCommand, File workingDor) {
        this(tokenizedCommand, System.getenv(), new ByteArrayInputStream(new byte[0]), workingDor);
    }

    public JobRequest(List<String> tokenizedCommand, Map<String, String> environment, InputStream inputStream, File workingDir) {
        this.tokenizedCommand = tokenizedCommand;
        this.commandLine = this.createCommandLine(tokenizedCommand);
        this.environment = environment;
        this.inputStream = inputStream;
        this.workingDir = workingDir;
    }

    private CommandLine createCommandLine(List<String> tokenizedCommand) {
        if (tokenizedCommand == null || tokenizedCommand.size() == 0) {
            throw new IllegalArgumentException("No tokenizedCommand specified.");
        }
        CommandLine commandLine = new CommandLine(tokenizedCommand.get(0));
        int size = tokenizedCommand.size();
        String[] arguments = tokenizedCommand.subList(1, size).toArray(new String[size - 1]);
        commandLine.addArguments(arguments, false);
        return commandLine;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.tokenizedCommand);
    }

    @Generated
    public List<String> getTokenizedCommand() {
        return this.tokenizedCommand;
    }

    @Generated
    public CommandLine getCommandLine() {
        return this.commandLine;
    }

    @Generated
    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Generated
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Generated
    public File getWorkingDir() {
        return this.workingDir;
    }
}

