/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.jobs.local;

import lombok.Generated;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Watchdog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceDestroyWatchdog
extends ExecuteWatchdog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForceDestroyWatchdog.class);
    private static final long GRACE_PERIOD_MS = 250L;
    private final long timeout;
    private Process process;

    public ForceDestroyWatchdog(long timeout) {
        super(timeout);
        this.timeout = timeout;
    }

    public synchronized void start(Process processToMonitor) {
        super.start(processToMonitor);
        this.process = processToMonitor;
    }

    public synchronized void timeoutOccured(Watchdog w) {
        super.timeoutOccured(w);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.process.isAlive()) {
            log.warn("Timeout: Waited {} ms for process to finish and process is still alive after sending SIGTERM signal. Sending SIGKILL.", (Object)(this.timeout + 250L));
            this.process.destroyForcibly();
        }
    }
}

