/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.jobs.local;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spinnaker.clouddriver.jobs.JobExecutionException;
import com.netflix.spinnaker.clouddriver.jobs.JobExecutor;
import com.netflix.spinnaker.clouddriver.jobs.JobRequest;
import com.netflix.spinnaker.clouddriver.jobs.JobResult;
import com.netflix.spinnaker.clouddriver.jobs.local.ForceDestroyWatchdog;
import com.netflix.spinnaker.clouddriver.jobs.local.ReaderConsumer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutorLocal
implements JobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobExecutorLocal.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-%d").build());
    private final long timeoutMinutes;

    public JobExecutorLocal(long timeoutMinutes) {
        this.timeoutMinutes = timeoutMinutes;
    }

    @Override
    public JobResult<String> runJob(JobRequest jobRequest) {
        return this.executeWrapper(jobRequest, this::execute);
    }

    @Override
    public <T> JobResult<T> runJob(JobRequest jobRequest, ReaderConsumer<T> readerConsumer) {
        return this.executeWrapper(jobRequest, request -> this.executeStreaming(request, readerConsumer));
    }

    private <T> JobResult<T> executeWrapper(JobRequest jobRequest, RequestExecutor<T> requestExecutor) {
        JobResult<T> jobResult;
        log.debug(String.format("Starting job: '%s'...", jobRequest.toString()));
        String jobId = UUID.randomUUID().toString();
        try {
            jobResult = requestExecutor.execute(jobRequest);
        }
        catch (IOException e) {
            throw new JobExecutionException(String.format("Error executing job: %s", jobRequest.toString()), e);
        }
        if (jobResult.isKilled()) {
            log.warn(String.format("Job %s timed out (after %d minutes)", jobId, this.timeoutMinutes));
        }
        return jobResult;
    }

    private JobResult<String> execute(JobRequest jobRequest) throws IOException {
        ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
        ByteArrayOutputStream stdErr = new ByteArrayOutputStream();
        Executor executor = this.buildExecutor((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdOut, (OutputStream)stdErr, jobRequest.getInputStream()), jobRequest);
        int exitValue = executor.execute(jobRequest.getCommandLine(), jobRequest.getEnvironment());
        return JobResult.builder().result(exitValue == 0 ? JobResult.Result.SUCCESS : JobResult.Result.FAILURE).killed(executor.getWatchdog().killedProcess()).output(stdOut.toString()).error(stdErr.toString()).build();
    }

    private <T> JobResult<T> executeStreaming(JobRequest jobRequest, ReaderConsumer<T> consumer) throws IOException {
        Object result;
        PipedOutputStream stdOut = new PipedOutputStream();
        ByteArrayOutputStream stdErr = new ByteArrayOutputStream();
        Executor executor = this.buildExecutor((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdOut, (OutputStream)stdErr, jobRequest.getInputStream()), jobRequest);
        Future<Object> futureResult = this.executorService.submit(() -> consumer.consume(new BufferedReader(new InputStreamReader(new PipedInputStream(stdOut)))));
        int exitValue = executor.execute(jobRequest.getCommandLine(), jobRequest.getEnvironment());
        try {
            result = futureResult.get(this.timeoutMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            executor.getWatchdog().destroyProcess();
            Thread.currentThread().interrupt();
            throw new JobExecutionException(String.format("Interrupted while executing job: %s", jobRequest.toString()), e);
        }
        catch (ExecutionException e) {
            throw new JobExecutionException(String.format("Error parsing output of job: %s", jobRequest.toString()), e.getCause());
        }
        catch (TimeoutException e) {
            throw new JobExecutionException(String.format("Timed out reading output of job: %s with exit value: %d. stderr: %s", jobRequest.toString(), exitValue, stdErr.toString()), e);
        }
        return JobResult.builder().result(exitValue == 0 ? JobResult.Result.SUCCESS : JobResult.Result.FAILURE).killed(executor.getWatchdog().killedProcess()).output(result).error(stdErr.toString()).build();
    }

    private Executor buildExecutor(ExecuteStreamHandler streamHandler, JobRequest jobRequest) {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler(streamHandler);
        executor.setWatchdog((ExecuteWatchdog)new ForceDestroyWatchdog(this.timeoutMinutes * 60L * 1000L));
        executor.setExitValues(null);
        if (jobRequest.getWorkingDir() != null) {
            executor.setWorkingDirectory(jobRequest.getWorkingDir());
        }
        return executor;
    }

    static interface RequestExecutor<U> {
        public JobResult<U> execute(JobRequest var1) throws IOException;
    }
}

