/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.model;

import com.netflix.spinnaker.clouddriver.model.LoadBalancer;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public interface Cluster {
    public String getName();

    default public Moniker getMoniker() {
        return NamerRegistry.getDefaultNamer().deriveMoniker((Object)this);
    }

    public String getType();

    public String getAccountName();

    public Set<? extends ServerGroup> getServerGroups();

    public Set<? extends LoadBalancer> getLoadBalancers();

    default public Map<String, Object> getExtraAttributes() {
        return Collections.EMPTY_MAP;
    }

    public static class SimpleCluster
    implements Cluster {
        String name;
        String type;
        String accountName;
        Set<ServerGroup> serverGroups;
        Set<LoadBalancer> loadBalancers;

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Override
        @Generated
        public String getAccountName() {
            return this.accountName;
        }

        @Generated
        public Set<ServerGroup> getServerGroups() {
            return this.serverGroups;
        }

        @Generated
        public Set<LoadBalancer> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Generated
        public SimpleCluster setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public SimpleCluster setType(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public SimpleCluster setAccountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Generated
        public SimpleCluster setServerGroups(Set<ServerGroup> serverGroups) {
            this.serverGroups = serverGroups;
            return this;
        }

        @Generated
        public SimpleCluster setLoadBalancers(Set<LoadBalancer> loadBalancers) {
            this.loadBalancers = loadBalancers;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleCluster)) {
                return false;
            }
            SimpleCluster other = (SimpleCluster)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$accountName = this.getAccountName();
            String other$accountName = other.getAccountName();
            if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
                return false;
            }
            Set<ServerGroup> this$serverGroups = this.getServerGroups();
            Set<ServerGroup> other$serverGroups = other.getServerGroups();
            if (this$serverGroups == null ? other$serverGroups != null : !((Object)this$serverGroups).equals(other$serverGroups)) {
                return false;
            }
            Set<LoadBalancer> this$loadBalancers = this.getLoadBalancers();
            Set<LoadBalancer> other$loadBalancers = other.getLoadBalancers();
            return !(this$loadBalancers == null ? other$loadBalancers != null : !((Object)this$loadBalancers).equals(other$loadBalancers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleCluster;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $accountName = this.getAccountName();
            result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
            Set<ServerGroup> $serverGroups = this.getServerGroups();
            result = result * 59 + ($serverGroups == null ? 43 : ((Object)$serverGroups).hashCode());
            Set<LoadBalancer> $loadBalancers = this.getLoadBalancers();
            result = result * 59 + ($loadBalancers == null ? 43 : ((Object)$loadBalancers).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Cluster.SimpleCluster(name=" + this.getName() + ", type=" + this.getType() + ", accountName=" + this.getAccountName() + ", serverGroups=" + this.getServerGroups() + ", loadBalancers=" + this.getLoadBalancers() + ")";
        }

        @Generated
        public SimpleCluster() {
        }

        @Generated
        public SimpleCluster(String name, String type, String accountName, Set<ServerGroup> serverGroups, Set<LoadBalancer> loadBalancers) {
            this.name = name;
            this.type = type;
            this.accountName = accountName;
            this.serverGroups = serverGroups;
            this.loadBalancers = loadBalancers;
        }
    }
}

