/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.model;

import com.netflix.spinnaker.clouddriver.model.Instance;
import com.netflix.spinnaker.clouddriver.model.ServerGroupManager;
import com.netflix.spinnaker.clouddriver.model.Summary;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public interface ServerGroup {
    public String getName();

    default public Moniker getMoniker() {
        return NamerRegistry.getDefaultNamer().deriveMoniker((Object)this);
    }

    default public String getType() {
        return this.getCloudProvider();
    }

    public String getCloudProvider();

    public String getRegion();

    public Boolean isDisabled();

    public Long getCreatedTime();

    public Set<String> getZones();

    public Set<? extends Instance> getInstances();

    public Set<String> getLoadBalancers();

    public Set<String> getSecurityGroups();

    public Map<String, Object> getLaunchConfig();

    default public String getInstanceType() {
        return null;
    }

    default public Map<String, Object> getTags() {
        return null;
    }

    public InstanceCounts getInstanceCounts();

    public Capacity getCapacity();

    public ImagesSummary getImagesSummary();

    @Deprecated
    public ImageSummary getImageSummary();

    default public List<ServerGroupManager.ServerGroupManagerSummary> getServerGroupManagers() {
        return new ArrayList<ServerGroupManager.ServerGroupManagerSummary>();
    }

    default public Map<String, String> getLabels() {
        return new HashMap<String, String>();
    }

    default public Map<String, Object> getExtraAttributes() {
        return Collections.EMPTY_MAP;
    }

    public static interface ImagesSummary
    extends Summary {
        public List<? extends ImageSummary> getSummaries();
    }

    public static interface ImageSummary
    extends Summary {
        public String getServerGroupName();

        public String getImageId();

        public String getImageName();

        public Map<String, Object> getImage();

        public Map<String, Object> getBuildInfo();
    }

    public static class Capacity {
        private Integer min;
        private Integer max;
        private Integer desired;

        public boolean isPinned() {
            return Objects.equals(this.max, this.desired) && Objects.equals(this.desired, this.min);
        }

        @Generated
        public static CapacityBuilder builder() {
            return new CapacityBuilder();
        }

        @Generated
        public Capacity() {
        }

        @Generated
        public Capacity(Integer min, Integer max, Integer desired) {
            this.min = min;
            this.max = max;
            this.desired = desired;
        }

        @Generated
        public Integer getMin() {
            return this.min;
        }

        @Generated
        public Integer getMax() {
            return this.max;
        }

        @Generated
        public Integer getDesired() {
            return this.desired;
        }

        @Generated
        public Capacity setMin(Integer min) {
            this.min = min;
            return this;
        }

        @Generated
        public Capacity setMax(Integer max) {
            this.max = max;
            return this;
        }

        @Generated
        public Capacity setDesired(Integer desired) {
            this.desired = desired;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capacity)) {
                return false;
            }
            Capacity other = (Capacity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$min = this.getMin();
            Integer other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            Integer this$max = this.getMax();
            Integer other$max = other.getMax();
            if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
                return false;
            }
            Integer this$desired = this.getDesired();
            Integer other$desired = other.getDesired();
            return !(this$desired == null ? other$desired != null : !((Object)this$desired).equals(other$desired));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Capacity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            Integer $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            Integer $desired = this.getDesired();
            result = result * 59 + ($desired == null ? 43 : ((Object)$desired).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServerGroup.Capacity(min=" + this.getMin() + ", max=" + this.getMax() + ", desired=" + this.getDesired() + ")";
        }

        @Generated
        public static class CapacityBuilder {
            @Generated
            private Integer min;
            @Generated
            private Integer max;
            @Generated
            private Integer desired;

            @Generated
            CapacityBuilder() {
            }

            @Generated
            public CapacityBuilder min(Integer min) {
                this.min = min;
                return this;
            }

            @Generated
            public CapacityBuilder max(Integer max) {
                this.max = max;
                return this;
            }

            @Generated
            public CapacityBuilder desired(Integer desired) {
                this.desired = desired;
                return this;
            }

            @Generated
            public Capacity build() {
                return new Capacity(this.min, this.max, this.desired);
            }

            @Generated
            public String toString() {
                return "ServerGroup.Capacity.CapacityBuilder(min=" + this.min + ", max=" + this.max + ", desired=" + this.desired + ")";
            }
        }
    }

    public static class InstanceCounts {
        private Integer total = 0;
        private Integer up = 0;
        private Integer down = 0;
        private Integer unknown = 0;
        private Integer outOfService = 0;
        private Integer starting = 0;

        @Generated
        public static InstanceCountsBuilder builder() {
            return new InstanceCountsBuilder();
        }

        @Generated
        public InstanceCounts() {
        }

        @Generated
        public InstanceCounts(Integer total, Integer up, Integer down, Integer unknown, Integer outOfService, Integer starting) {
            this.total = total;
            this.up = up;
            this.down = down;
            this.unknown = unknown;
            this.outOfService = outOfService;
            this.starting = starting;
        }

        @Generated
        public Integer getTotal() {
            return this.total;
        }

        @Generated
        public Integer getUp() {
            return this.up;
        }

        @Generated
        public Integer getDown() {
            return this.down;
        }

        @Generated
        public Integer getUnknown() {
            return this.unknown;
        }

        @Generated
        public Integer getOutOfService() {
            return this.outOfService;
        }

        @Generated
        public Integer getStarting() {
            return this.starting;
        }

        @Generated
        public InstanceCounts setTotal(Integer total) {
            this.total = total;
            return this;
        }

        @Generated
        public InstanceCounts setUp(Integer up) {
            this.up = up;
            return this;
        }

        @Generated
        public InstanceCounts setDown(Integer down) {
            this.down = down;
            return this;
        }

        @Generated
        public InstanceCounts setUnknown(Integer unknown) {
            this.unknown = unknown;
            return this;
        }

        @Generated
        public InstanceCounts setOutOfService(Integer outOfService) {
            this.outOfService = outOfService;
            return this;
        }

        @Generated
        public InstanceCounts setStarting(Integer starting) {
            this.starting = starting;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceCounts)) {
                return false;
            }
            InstanceCounts other = (InstanceCounts)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$total = this.getTotal();
            Integer other$total = other.getTotal();
            if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                return false;
            }
            Integer this$up = this.getUp();
            Integer other$up = other.getUp();
            if (this$up == null ? other$up != null : !((Object)this$up).equals(other$up)) {
                return false;
            }
            Integer this$down = this.getDown();
            Integer other$down = other.getDown();
            if (this$down == null ? other$down != null : !((Object)this$down).equals(other$down)) {
                return false;
            }
            Integer this$unknown = this.getUnknown();
            Integer other$unknown = other.getUnknown();
            if (this$unknown == null ? other$unknown != null : !((Object)this$unknown).equals(other$unknown)) {
                return false;
            }
            Integer this$outOfService = this.getOutOfService();
            Integer other$outOfService = other.getOutOfService();
            if (this$outOfService == null ? other$outOfService != null : !((Object)this$outOfService).equals(other$outOfService)) {
                return false;
            }
            Integer this$starting = this.getStarting();
            Integer other$starting = other.getStarting();
            return !(this$starting == null ? other$starting != null : !((Object)this$starting).equals(other$starting));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InstanceCounts;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            Integer $up = this.getUp();
            result = result * 59 + ($up == null ? 43 : ((Object)$up).hashCode());
            Integer $down = this.getDown();
            result = result * 59 + ($down == null ? 43 : ((Object)$down).hashCode());
            Integer $unknown = this.getUnknown();
            result = result * 59 + ($unknown == null ? 43 : ((Object)$unknown).hashCode());
            Integer $outOfService = this.getOutOfService();
            result = result * 59 + ($outOfService == null ? 43 : ((Object)$outOfService).hashCode());
            Integer $starting = this.getStarting();
            result = result * 59 + ($starting == null ? 43 : ((Object)$starting).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServerGroup.InstanceCounts(total=" + this.getTotal() + ", up=" + this.getUp() + ", down=" + this.getDown() + ", unknown=" + this.getUnknown() + ", outOfService=" + this.getOutOfService() + ", starting=" + this.getStarting() + ")";
        }

        @Generated
        public static class InstanceCountsBuilder {
            @Generated
            private Integer total;
            @Generated
            private Integer up;
            @Generated
            private Integer down;
            @Generated
            private Integer unknown;
            @Generated
            private Integer outOfService;
            @Generated
            private Integer starting;

            @Generated
            InstanceCountsBuilder() {
            }

            @Generated
            public InstanceCountsBuilder total(Integer total) {
                this.total = total;
                return this;
            }

            @Generated
            public InstanceCountsBuilder up(Integer up) {
                this.up = up;
                return this;
            }

            @Generated
            public InstanceCountsBuilder down(Integer down) {
                this.down = down;
                return this;
            }

            @Generated
            public InstanceCountsBuilder unknown(Integer unknown) {
                this.unknown = unknown;
                return this;
            }

            @Generated
            public InstanceCountsBuilder outOfService(Integer outOfService) {
                this.outOfService = outOfService;
                return this;
            }

            @Generated
            public InstanceCountsBuilder starting(Integer starting) {
                this.starting = starting;
                return this;
            }

            @Generated
            public InstanceCounts build() {
                return new InstanceCounts(this.total, this.up, this.down, this.unknown, this.outOfService, this.starting);
            }

            @Generated
            public String toString() {
                return "ServerGroup.InstanceCounts.InstanceCountsBuilder(total=" + this.total + ", up=" + this.up + ", down=" + this.down + ", unknown=" + this.unknown + ", outOfService=" + this.outOfService + ", starting=" + this.starting + ")";
            }
        }
    }
}

