/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.names;

import com.netflix.spinnaker.clouddriver.names.NamingStrategy;
import com.netflix.spinnaker.moniker.Namer;
import com.netflix.spinnaker.moniker.frigga.FriggaReflectiveNamer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamerRegistry {
    private static Namer<Object> DEFAULT_NAMER = new FriggaReflectiveNamer();
    private static ProviderLookup providerLookup = new ProviderLookup();
    private final List<NamingStrategy> namingStrategies;

    public static Namer<Object> getDefaultNamer() {
        return DEFAULT_NAMER;
    }

    public static ProviderLookup lookup() {
        return providerLookup;
    }

    public NamerRegistry(List<NamingStrategy> namingStrategies) {
        this.namingStrategies = namingStrategies;
    }

    public Namer getNamingStrategy(String strategyName) {
        return this.namingStrategies.stream().filter(strategy -> strategy.getName().equalsIgnoreCase(strategyName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find naming strategy '" + strategyName + "'"));
    }

    public static class ProviderLookup {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ProviderLookup.class);
        private ConcurrentHashMap<String, AccountLookup> map = new ConcurrentHashMap();

        public AccountLookup withProvider(String providerName) {
            if (!this.map.containsKey(providerName)) {
                log.debug("Looking up a namer for a non-registered provider");
                AccountLookup result = new AccountLookup();
                this.map.put(providerName, result);
                return result;
            }
            return this.map.get(providerName);
        }
    }

    public static class AccountLookup {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(AccountLookup.class);
        private ConcurrentHashMap<String, ResourceLookup> map = new ConcurrentHashMap();

        public ResourceLookup withAccount(String accountName) {
            if (!this.map.containsKey(accountName)) {
                log.debug("Looking up a namer for a non-registered account");
                ResourceLookup result = new ResourceLookup();
                this.map.put(accountName, result);
                return result;
            }
            return this.map.get(accountName);
        }
    }

    public static class ResourceLookup {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ResourceLookup.class);
        private ConcurrentHashMap<Class<?>, Namer<?>> map = new ConcurrentHashMap();

        public <T> Namer<T> withResource(Class<T> resource) {
            if (!this.map.containsKey(resource)) {
                log.debug("Looking up a namer for a non-registered resource");
                return NamerRegistry.getDefaultNamer();
            }
            return this.map.get(resource);
        }

        public <T> void setNamer(Class<T> resource, Namer<T> namer) {
            this.map.put(resource, namer);
        }
    }
}

