/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.orchestration;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.GlobalDescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDescriptionValidator<T>
extends DescriptionValidator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeDescriptionValidator.class);
    private final String operationName;
    private final String cloudProvider;
    private final DescriptionValidator<T> validator;
    private final List<GlobalDescriptionValidator> globalValidators;

    public CompositeDescriptionValidator(String operationName, String cloudProvider, DescriptionValidator<T> validator, List<GlobalDescriptionValidator> extensibleValidators) {
        this.operationName = operationName;
        this.cloudProvider = cloudProvider;
        this.validator = validator;
        this.globalValidators = extensibleValidators;
    }

    public void validate(List<T> priorDescriptions, T description, ValidationErrors errors) {
        if (this.globalValidators != null) {
            this.globalValidators.forEach(v -> {
                if (v.handles(description)) {
                    v.validate(this.operationName, priorDescriptions, description, errors);
                }
            });
        }
        if (this.validator == null) {
            String operationName = Optional.ofNullable(description).map(it -> it.getClass().getSimpleName()).orElse("UNKNOWN");
            log.warn(String.format("No validator found for operation %s and cloud provider %s", operationName, this.cloudProvider));
        } else {
            this.validator.validate(priorDescriptions, description, errors);
        }
    }

    @Generated
    public DescriptionValidator<T> getValidator() {
        return this.validator;
    }
}

